/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline;

import java.sql.Driver;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import migratedb.v1.core.api.configuration.Configuration;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DriverSupport {
    public static final String APPLICATION_NAME = "MigrateDB";
    public static final Pattern defaultJdbcCredentialsPattern = Pattern.compile("password=([^;&]*).*", 2);

    public String getName();

    public boolean handlesJdbcUrl(String var1);

    default public boolean detectUserRequiredByUrl(String url) {
        return true;
    }

    default public boolean detectPasswordRequiredByUrl(String url) {
        return true;
    }

    default public Pattern getJdbcCredentialsPattern() {
        return defaultJdbcCredentialsPattern;
    }

    default public String redactJdbcUrl(String url) {
        Matcher matcher = this.getJdbcCredentialsPattern().matcher(url);
        if (matcher.find()) {
            String password = matcher.group(1);
            return url.replace(password, "***");
        }
        return url;
    }

    public String getDriverClass(String var1, ClassLoader var2);

    default public @Nullable String getBackupDriverClass(String url, ClassLoader classLoader) {
        return null;
    }

    default public String instantiateClassExtendedErrorMessage() {
        return "";
    }

    default public void modifyDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
    }

    default public void modifyConfigConnectionProps(Configuration config, Properties props, ClassLoader classLoader) {
    }

    default public void modifyOverridingConnectionProps(Map<String, String> props) {
    }

    default public void shutdownDatabase(String url, Driver driver) {
    }
}

