/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline;

import java.io.PrintStream;
import migratedb.v1.commandline.Arguments;
import migratedb.v1.commandline.LogLevel;
import migratedb.v1.core.api.logging.LogSystem;

public class ConsoleLogSystem
implements LogSystem {
    private final Arguments commandLineArguments;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final LogLevel level;

    public ConsoleLogSystem(Arguments commandLineArguments, PrintStream stdout, PrintStream stderr) {
        this.commandLineArguments = commandLineArguments;
        this.stdout = stdout;
        this.stderr = stderr;
        this.level = commandLineArguments.getLogLevel();
    }

    public boolean isDebugEnabled(String logName) {
        return this.level == LogLevel.DEBUG;
    }

    public void debug(String logName, String message) {
        if (this.isDebugEnabled(logName)) {
            this.stdout.println("DEBUG   " + message);
        }
    }

    public void info(String logName, String message) {
        if (this.level.compareTo(LogLevel.INFO) <= 0) {
            this.stdout.println("INFO    " + message);
        }
    }

    public void warn(String logName, String message) {
        this.stdout.println("WARNING " + message);
    }

    public void error(String logName, String message) {
        this.stderr.println("ERROR   " + message);
    }

    public void error(String logName, String message, Exception e) {
        this.stderr.println("ERROR   " + message);
        e.printStackTrace(this.stderr);
    }
}

