/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.commandline;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import migratedb.v1.commandline.LogLevel;
import migratedb.v1.core.api.MigrateDbException;
import migratedb.v1.core.api.MigrationState;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.internal.util.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Arguments {
    private static final String DEBUG_FLAG = "-X";
    private static final String QUIET_FLAG = "-q";
    private static final String SUPPRESS_PROMPT_FLAG = "-n";
    private static final List<String> PRINT_VERSION_AND_EXIT_FLAGS = Arrays.asList("-v", "--version");
    private static final List<String> PRINT_USAGE_FLAGS = Arrays.asList("-?", "-h", "--help");
    private static final String FILE_SYSTEM_URI = "fileSystemUri";
    private static final String DRIVER_NAMES = "driverNames";
    private static final String INSTALLATION_DIR = "baseDirectory";
    private static final String OUTPUT_FILE = "outputFile";
    private static final String OUTPUT_TYPE = "outputType";
    private static final String CONFIG_FILE_ENCODING = "configFileEncoding";
    private static final String CONFIG_FILES = "configFiles";
    private static final String WORKING_DIRECTORY = "workingDirectory";
    private static final String INFO_SINCE_DATE = "infoSinceDate";
    private static final String INFO_UNTIL_DATE = "infoUntilDate";
    private static final String INFO_SINCE_VERSION = "infoSinceVersion";
    private static final String INFO_UNTIL_VERSION = "infoUntilVersion";
    private static final String INFO_OF_STATE = "infoOfState";
    private static final DateTimeFormatter OLD_DATE_FORMAT = DateTimeFormatter.ofPattern("dd/MM/uuuu HH:mm", Locale.ROOT);
    private static final List<String> VALID_OPERATIONS_AND_FLAGS = Arguments.getValidOperationsAndFlags();
    private final String[] args;

    private static List<String> getValidOperationsAndFlags() {
        ArrayList<String> operationsAndFlags = new ArrayList<String>(Arrays.asList(DEBUG_FLAG, QUIET_FLAG, SUPPRESS_PROMPT_FLAG, "help", "migrate", "info", "validate", "baseline", "repair", "download-drivers", "liberate"));
        operationsAndFlags.addAll(PRINT_VERSION_AND_EXIT_FLAGS);
        operationsAndFlags.addAll(PRINT_USAGE_FLAGS);
        return operationsAndFlags;
    }

    public Arguments(String[] args) {
        this.args = args;
    }

    private static boolean isFlagSet(String[] args, String flag) {
        for (String arg : args) {
            if (!flag.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFlagSet(String[] args, List<String> flags) {
        for (String flag : flags) {
            if (!Arguments.isFlagSet(args, flag)) continue;
            return true;
        }
        return false;
    }

    private static String getArgumentValue(String argName, String[] allArgs) {
        for (String arg : allArgs) {
            if (!arg.startsWith("-" + argName + "=")) continue;
            return Arguments.parseConfigurationOptionValueFromArg(arg);
        }
        return "";
    }

    private static String parseConfigurationOptionValueFromArg(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length() - 1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static List<String> getOperationsFromArgs(String[] args) {
        ArrayList<String> operations = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            operations.add(arg);
        }
        return operations;
    }

    private static List<String> getConfigFilesFromArgs(String[] args) {
        String configFilesCommaSeparatedList = Arguments.getArgumentValue(CONFIG_FILES, args);
        return Arrays.asList(StringUtils.tokenizeToStringArray((String)configFilesCommaSeparatedList, (String)","));
    }

    private static Map<String, String> getConfigurationFromArgs(String[] args) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (String arg : args) {
            String configurationOptionName;
            if (!Arguments.isConfigurationArg(arg) || Arguments.isConfigurationOptionCommandlineOnly(configurationOptionName = Arguments.getConfigurationOptionNameFromArg(arg))) continue;
            configuration.put("migratedb." + configurationOptionName, Arguments.parseConfigurationOptionValueFromArg(arg));
        }
        return configuration;
    }

    private static boolean isConfigurationOptionCommandlineOnly(String configurationOptionName) {
        return OUTPUT_FILE.equals(configurationOptionName) || OUTPUT_TYPE.equals(configurationOptionName) || WORKING_DIRECTORY.equals(configurationOptionName) || INFO_SINCE_DATE.equals(configurationOptionName) || INFO_UNTIL_DATE.equals(configurationOptionName) || INFO_SINCE_VERSION.equals(configurationOptionName) || INFO_UNTIL_VERSION.equals(configurationOptionName) || INFO_OF_STATE.equals(configurationOptionName) || INSTALLATION_DIR.equals(configurationOptionName) || DRIVER_NAMES.equals(configurationOptionName) || FILE_SYSTEM_URI.equalsIgnoreCase(configurationOptionName);
    }

    private static String getConfigurationOptionNameFromArg(String arg) {
        int index = arg.indexOf("=");
        return arg.substring(1, index);
    }

    private static boolean isConfigurationArg(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    public void validate() {
        for (String arg : this.args) {
            if (Arguments.isConfigurationArg(arg) || VALID_OPERATIONS_AND_FLAGS.contains(arg)) continue;
            throw new MigrateDbException("Invalid argument: " + arg);
        }
        String outputTypeValue = Arguments.getArgumentValue(OUTPUT_TYPE, this.args).toLowerCase(Locale.ENGLISH);
        if (!"json".equals(outputTypeValue) && !outputTypeValue.isEmpty()) {
            throw new MigrateDbException("'" + outputTypeValue + "' is an invalid value for the -outputType option. Use 'json'.");
        }
    }

    public boolean shouldSuppressPrompt() {
        return Arguments.isFlagSet(this.args, SUPPRESS_PROMPT_FLAG);
    }

    public boolean shouldPrintVersionAndExit() {
        return Arguments.isFlagSet(this.args, PRINT_VERSION_AND_EXIT_FLAGS);
    }

    public boolean shouldOutputJson() {
        return "json".equalsIgnoreCase(Arguments.getArgumentValue(OUTPUT_TYPE, this.args));
    }

    public boolean shouldPrintUsage() {
        return Arguments.isFlagSet(this.args, PRINT_USAGE_FLAGS) || this.getOperations().isEmpty();
    }

    public LogLevel getLogLevel() {
        if (Arguments.isFlagSet(this.args, QUIET_FLAG)) {
            return LogLevel.WARN;
        }
        if (Arguments.isFlagSet(this.args, DEBUG_FLAG)) {
            return LogLevel.DEBUG;
        }
        return LogLevel.INFO;
    }

    public boolean hasOperation(String operation) {
        return this.getOperations().contains(operation);
    }

    public List<String> getOperations() {
        return Arguments.getOperationsFromArgs(this.args);
    }

    public List<String> getConfigFiles() {
        return Arguments.getConfigFilesFromArgs(this.args);
    }

    public String getOutputFile() {
        return Arguments.getArgumentValue(OUTPUT_FILE, this.args);
    }

    public String getWorkingDirectory() {
        return Arguments.getArgumentValue(WORKING_DIRECTORY, this.args);
    }

    public @Nullable Instant getInfoSinceDate() {
        return this.parseDate(INFO_SINCE_DATE);
    }

    public @Nullable Instant getInfoUntilDate() {
        return this.parseDate(INFO_UNTIL_DATE);
    }

    public @Nullable Version getInfoSinceVersion() {
        return this.parseVersion(INFO_SINCE_VERSION);
    }

    public @Nullable Version getInfoUntilVersion() {
        return this.parseVersion(INFO_UNTIL_VERSION);
    }

    public @Nullable MigrationState getInfoOfState() {
        String stateStr = Arguments.getArgumentValue(INFO_OF_STATE, this.args);
        if (!StringUtils.hasText((String)stateStr)) {
            return null;
        }
        return MigrationState.valueOf((String)stateStr.toUpperCase(Locale.ENGLISH));
    }

    public String getInstallationDirectory() {
        String arg = Arguments.getArgumentValue(INSTALLATION_DIR, this.args);
        return arg.isEmpty() ? System.getProperty("user.dir") : arg;
    }

    public List<String> getDriverNames() {
        String commaSeparatedList = Arguments.getArgumentValue(DRIVER_NAMES, this.args);
        return Arrays.asList(StringUtils.tokenizeToStringArray((String)commaSeparatedList, (String)","));
    }

    private @Nullable Version parseVersion(String argument) {
        String versionStr = Arguments.getArgumentValue(argument, this.args);
        if (versionStr.isEmpty()) {
            return null;
        }
        return Version.parse((String)versionStr);
    }

    private @Nullable Instant parseDate(String argument) {
        String dateStr = Arguments.getArgumentValue(argument, this.args);
        if (dateStr.isEmpty()) {
            return null;
        }
        Instant result = null;
        for (DateTimeFormatter format : List.of(DateTimeFormatter.ISO_DATE_TIME, OLD_DATE_FORMAT)) {
            try {
                TemporalAccessor parsed = format.parseBest(dateStr, ZonedDateTime::from, OffsetDateTime::from, LocalDateTime::from);
                if (parsed instanceof ZonedDateTime) {
                    result = ((ZonedDateTime)parsed).toInstant();
                    continue;
                }
                if (parsed instanceof OffsetDateTime) {
                    result = ((OffsetDateTime)parsed).toInstant();
                    continue;
                }
                if (!(parsed instanceof LocalDateTime)) continue;
                result = ((LocalDateTime)parsed).atZone(ZoneId.systemDefault()).toInstant();
            }
            catch (DateTimeParseException dateTimeParseException) {}
        }
        if (result == null) {
            throw new MigrateDbException("'" + dateStr + "' is an invalid value for the " + argument + " option. The expected format is either ISO-8601 date/time or '" + OLD_DATE_FORMAT + "', like '13/10/2020 16:30'.");
        }
        return result;
    }

    public boolean isOutputFileSet() {
        return !this.getOutputFile().isEmpty();
    }

    public boolean isWorkingDirectorySet() {
        return !this.getWorkingDirectory().isEmpty();
    }

    public String getConfigFileEncoding() {
        return Arguments.getArgumentValue(CONFIG_FILE_ENCODING, this.args);
    }

    public boolean isConfigFileEncodingSet() {
        return !this.getConfigFileEncoding().isEmpty();
    }

    public Map<String, String> getConfiguration() {
        return Arguments.getConfigurationFromArgs(this.args);
    }

    public FileSystem getFileSystem() {
        String uri = Arguments.getArgumentValue(FILE_SYSTEM_URI, this.args);
        if (uri.isEmpty()) {
            return FileSystems.getDefault();
        }
        return FileSystems.getFileSystem(URI.create(uri));
    }
}

