/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.vertx.lang.typescript.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class Source {
    private final String filename;
    private final URI uri;
    private final String contents;
    private String digest;

    public Source(URI uri, String contents) {
        this.filename = Source.basename(uri.toString());
        this.uri = uri;
        this.contents = contents;
    }

    public static Source fromURL(URL url, Charset cs) throws IOException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Illegal URI", e);
        }
        try (InputStream is = url.openStream();){
            Source source = Source.fromStream(is, uri, cs);
            return source;
        }
    }

    public static Source fromFile(File f, Charset cs) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            Source source = Source.fromStream(is, f.toURI(), cs);
            return source;
        }
    }

    public static Source fromStream(InputStream is, URI uri, Charset cs) throws IOException {
        byte[] barr = Source.readFully(is);
        String source = new String(barr, cs);
        return new Source(uri, source);
    }

    public String getFilename() {
        return this.filename;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getDigest() {
        if (this.digest == null) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            byte[] digestBytes = md.digest(this.contents.getBytes(StandardCharsets.UTF_8));
            this.digest = Base64.getUrlEncoder().encodeToString(digestBytes);
        }
        return this.digest;
    }

    public String toString() {
        return this.contents;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    private static String basename(String str) {
        int sl = str.lastIndexOf(47);
        if (sl >= 0) {
            return str.substring(sl + 1);
        }
        return str;
    }

    private static byte[] readFully(InputStream is) throws IOException {
        byte[] buf = new byte[8192];
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int read;
            while ((read = is.read(buf, 0, buf.length)) > 0) {
                baos.write(buf, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }
}

