/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.vertx.lang.typescript.compiler;

import de.undercouch.vertx.lang.typescript.compiler.Source;
import de.undercouch.vertx.lang.typescript.compiler.SourceFactory;
import de.undercouch.vertx.lang.typescript.compiler.TypeScriptCompiler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;

public class NodeCompiler
implements TypeScriptCompiler {
    private static final String TYPESCRIPT_JS = "typescript/lib/tsc.js";
    private static final String NODE_COMPILER_SYS_JS = "vertx-typescript/util/node_compiler_sys.js";
    private File temporaryCompiler;

    private String getTemporaryCompiler(SourceFactory sourceFactory) throws IOException {
        if (this.temporaryCompiler == null) {
            Source tscSrc = sourceFactory.getSource(TYPESCRIPT_JS, null);
            Source nodeCompilerSysSrc = sourceFactory.getSource(NODE_COMPILER_SYS_JS, null);
            String tscSrcStr = tscSrc.toString();
            tscSrcStr = tscSrcStr.replaceFirst("(?m)^ts\\.executeCommandLine", Matcher.quoteReplacement(nodeCompilerSysSrc.toString()) + "\n$0");
            this.temporaryCompiler = File.createTempFile("VERTX_TYPESCRIPT_", ".js");
            this.temporaryCompiler.deleteOnExit();
            try (OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(this.temporaryCompiler));){
                w.write(tscSrcStr);
                ((Writer)w).flush();
            }
        }
        return this.temporaryCompiler.getAbsolutePath();
    }

    @Override
    public String compile(String filename, SourceFactory sourceFactory) throws IOException {
        int code;
        String line;
        String temporaryCompilerPath = this.getTemporaryCompiler(sourceFactory);
        ProcessBuilder processBuilder = new ProcessBuilder("node", temporaryCompilerPath, "--module", "commonjs", filename);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        InputStream pis = process.getInputStream();
        OutputStream pos = process.getOutputStream();
        BufferedReader pr = new BufferedReader(new InputStreamReader(pis, StandardCharsets.UTF_8));
        OutputStreamWriter pw = new OutputStreamWriter(pos, StandardCharsets.UTF_8);
        StringBuffer out = new StringBuffer();
        while ((line = pr.readLine()) != null) {
            String fileToRead;
            if (line.startsWith("VERTX_TYPESCRIPT_READFILE")) {
                int length;
                String contents;
                fileToRead = line.substring("VERTX_TYPESCRIPT_READFILE".length());
                try {
                    Source src = sourceFactory.getSource(fileToRead, filename);
                    contents = src.toString();
                    length = contents.length();
                }
                catch (FileNotFoundException e) {
                    contents = "";
                    length = -1;
                }
                ((Writer)pw).append(String.valueOf(length));
                pw.append(' ');
                ((Writer)pw).append(contents);
                ((Writer)pw).flush();
                continue;
            }
            if (line.startsWith("VERTX_TYPESCRIPT_FILEEXISTS")) {
                boolean found;
                fileToRead = line.substring("VERTX_TYPESCRIPT_FILEEXISTS".length());
                try {
                    sourceFactory.getSource(fileToRead, filename);
                    found = true;
                }
                catch (FileNotFoundException e) {
                    found = false;
                }
                pw.append(found ? (char)'1' : '0');
                ((Writer)pw).flush();
                continue;
            }
            out.append(line + "\n");
        }
        try {
            code = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Node.js died prematurely", e);
        }
        if (code != 0) {
            throw new IllegalStateException("Could not compile script. Exit code: " + code + "\n" + out.toString());
        }
        return out.toString();
    }

    public static boolean supportsNode() {
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("node", "-v");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            InputStream pis = process.getInputStream();
            BufferedReader pr = new BufferedReader(new InputStreamReader(pis, StandardCharsets.UTF_8));
            String version = null;
            while ((line = pr.readLine()) != null) {
                if (version != null) continue;
                version = line;
            }
            int code = process.waitFor();
            return code == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }
}

