/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.vertx.lang.typescript.compiler;

import de.undercouch.vertx.lang.typescript.compiler.Source;
import de.undercouch.vertx.lang.typescript.compiler.SourceFactory;
import de.undercouch.vertx.lang.typescript.compiler.TypeScriptCompiler;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class EngineCompiler
implements TypeScriptCompiler {
    private static final String TYPESCRIPT_JS = "typescript/lib/typescriptServices.js";
    private static final String COMPILE_JS = "vertx-typescript/util/compile.js";
    private ScriptEngine engine;

    private synchronized ScriptEngine getEngine() {
        if (this.engine != null) {
            return this.engine;
        }
        ScriptEngineManager mgr = new ScriptEngineManager();
        this.engine = mgr.getEngineByName("nashorn");
        if (this.engine == null) {
            throw new IllegalStateException("Could not find Nashorn JavaScript engine.");
        }
        this.loadScript(TYPESCRIPT_JS, src -> {
            String startStr = "ts.Diagnostics = {";
            String endStr = "};";
            int start = src.indexOf(startStr);
            int end = src.indexOf(endStr, start);
            String diagnostics = src.substring(start + startStr.length(), end);
            CharSequence[] diagLines = diagnostics.split("\n");
            for (int i = 0; i < diagLines.length; ++i) {
                diagLines[i] = diagLines[i].replaceFirst("^\\s*(.+?):", "ts.Diagnostics.$1 =");
            }
            String newDiagnostics = startStr + "};\n" + String.join((CharSequence)"\n", diagLines) + ";";
            src = src.substring(0, start) + newDiagnostics + src.substring(end + endStr.length());
            return src;
        });
        this.loadScript(COMPILE_JS, null);
        return this.engine;
    }

    private void loadScript(String name, Function<String, String> processSource) {
        URL url = this.getClass().getClassLoader().getResource(name);
        if (url == null) {
            throw new IllegalStateException("Cannot find " + name + " on classpath");
        }
        try {
            String src = Source.fromURL(url, StandardCharsets.UTF_8).toString();
            if (processSource != null) {
                src = processSource.apply(src);
            }
            this.engine.eval(src);
        }
        catch (IOException | ScriptException e) {
            throw new IllegalStateException("Could not evaluate " + name, e);
        }
    }

    @Override
    public String compile(String filename, SourceFactory sourceFactory) throws IOException {
        ScriptEngine e = this.getEngine();
        ScriptObjectMirror o = (ScriptObjectMirror)e.get("compileTypescript");
        return (String)o.call(null, new Object[]{filename, sourceFactory});
    }
}

