/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.vertx.lang.typescript.cache;

import de.undercouch.vertx.lang.typescript.cache.Cache;
import de.undercouch.vertx.lang.typescript.cache.InMemoryCache;
import de.undercouch.vertx.lang.typescript.compiler.Source;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class DiskCache
implements Cache {
    private final File cacheDir;
    private final Cache memoryCache = new InMemoryCache();

    public DiskCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    private File getFileOnDisk(Source source) {
        return new File(this.cacheDir, source.getDigest());
    }

    @Override
    public String get(Source src) {
        File f;
        String result = this.memoryCache.get(src);
        if (result == null && (f = this.getFileOnDisk(src)).exists()) {
            try {
                Source rs = Source.fromFile(f, StandardCharsets.UTF_8);
                result = rs.toString();
                this.memoryCache.put(src, result);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void put(Source src, String value) {
        this.memoryCache.put(src, value);
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
        File f = this.getFileOnDisk(src);
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));){
            w.write(value);
            ((Writer)w).flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

