/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.vertx.lang.typescript;

import de.undercouch.vertx.lang.typescript.TypeScriptClassLoader;
import de.undercouch.vertx.lang.typescript.cache.Cache;
import de.undercouch.vertx.lang.typescript.cache.DiskCache;
import de.undercouch.vertx.lang.typescript.cache.InMemoryCache;
import de.undercouch.vertx.lang.typescript.cache.NoopCache;
import de.undercouch.vertx.lang.typescript.compiler.EngineCompiler;
import de.undercouch.vertx.lang.typescript.compiler.NodeCompiler;
import de.undercouch.vertx.lang.typescript.compiler.TypeScriptCompiler;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.lang.js.JSVerticleFactory;
import java.io.File;

public class TypeScriptVerticleFactory
implements VerticleFactory {
    public static final String PROP_NAME_CACHE = "vertx.typescriptCache";
    public static final String PROP_NAME_CACHE_DIR = "vertx.typescriptCacheDir";
    public static final String PROP_NAME_DISABLE_NODE_COMPILER = "vertx.disableNodeCompiler";
    public static final String CACHE_NONE = "none";
    public static final String CACHE_MEMORY = "memory";
    public static final String CACHE_DISK = "disk";
    public static final String DEFAULT_CACHE_DIR = "typescript_code_cache";
    private static final String CACHE_MODE = System.getProperty("vertx.typescriptCache", "none");
    private static final String CACHE_DIR = System.getProperty("vertx.typescriptCacheDir", "typescript_code_cache");
    private static final Cache CACHE;
    private final VerticleFactory delegateFactory = new JSVerticleFactory();
    private TypeScriptCompiler compiler;

    public void init(Vertx vertx) {
        this.delegateFactory.init(vertx);
    }

    public String prefix() {
        return "ts";
    }

    public Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
        Verticle v = this.delegateFactory.createVerticle(verticleName, classLoader);
        return new TypeScriptVerticle(v);
    }

    private TypeScriptCompiler getTypeScriptCompiler() {
        boolean disableNodeCompiler = Boolean.getBoolean(PROP_NAME_DISABLE_NODE_COMPILER);
        if (this.compiler == null) {
            this.compiler = !disableNodeCompiler && NodeCompiler.supportsNode() ? new NodeCompiler() : new EngineCompiler();
        }
        return this.compiler;
    }

    static {
        if (CACHE_MODE.equalsIgnoreCase(CACHE_NONE)) {
            CACHE = new NoopCache();
        } else if (CACHE_MODE.equalsIgnoreCase(CACHE_MEMORY)) {
            CACHE = new InMemoryCache();
        } else if (CACHE_MODE.equalsIgnoreCase(CACHE_DISK)) {
            CACHE = new DiskCache(new File(CACHE_DIR));
        } else {
            throw new RuntimeException("Illegal value for vertx.typescriptCache: " + CACHE_MODE);
        }
    }

    public class TypeScriptVerticle
    implements Verticle {
        private final Verticle delegateVerticle;

        public TypeScriptVerticle(Verticle delegateVerticle) {
            this.delegateVerticle = delegateVerticle;
        }

        public Vertx getVertx() {
            return this.delegateVerticle.getVertx();
        }

        public void init(Vertx vertx, Context context) {
            this.delegateVerticle.init(vertx, context);
        }

        public void start(Future<Void> startFuture) throws Exception {
            this.delegateVerticle.getVertx().executeBlocking(future -> {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(new TypeScriptClassLoader(cl, TypeScriptVerticleFactory.this.getTypeScriptCompiler(), CACHE));
                try {
                    this.delegateVerticle.start(future);
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }, res -> {
                if (res.succeeded()) {
                    startFuture.complete();
                } else {
                    startFuture.fail(res.cause());
                }
            });
        }

        public void stop(Future<Void> stopFuture) throws Exception {
            this.delegateVerticle.stop(stopFuture);
        }
    }
}

