/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.vertx.lang.typescript;

import de.undercouch.vertx.lang.typescript.cache.Cache;
import de.undercouch.vertx.lang.typescript.compiler.Source;
import de.undercouch.vertx.lang.typescript.compiler.SourceFactory;
import de.undercouch.vertx.lang.typescript.compiler.TypeScriptCompiler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class TypeScriptClassLoader
extends ClassLoader
implements SourceFactory {
    private Map<String, Source> sourceCache = new HashMap<String, Source>();
    private final Cache codeCache;
    private final TypeScriptCompiler compiler;

    public TypeScriptClassLoader(ClassLoader parent, TypeScriptCompiler compiler, Cache codeCache) {
        super(parent);
        this.compiler = compiler;
        this.codeCache = codeCache;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            String lowerName = name.toLowerCase();
            if (lowerName.endsWith(".ts")) {
                return this.load(name);
            }
            if (lowerName.endsWith(".ts.js")) {
                return this.load(name.substring(0, name.length() - 3));
            }
            InputStream r = super.getResourceAsStream(name);
            if (r == null && lowerName.endsWith(".js")) {
                return this.load(name.substring(0, name.length() - 3) + ".ts");
            }
            return r;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Source getSource(String name, String baseFilename) throws IOException {
        Source result;
        Source baseSource;
        if (baseFilename != null && (name.startsWith("./") || name.startsWith("../")) && (baseSource = this.getSource(baseFilename, null)) != null) {
            name = baseSource.getURI().resolve(name).normalize().toString();
        }
        if ((result = this.sourceCache.get(name)) == null) {
            URL u;
            if (name.matches("^[a-z]+:/.*")) {
                try {
                    u = new URL(name);
                }
                catch (MalformedURLException e) {
                    u = null;
                }
            } else {
                u = null;
            }
            if (u == null) {
                u = this.getParent().getResource(name);
            }
            if (u != null) {
                result = Source.fromURL(u, StandardCharsets.UTF_8);
            }
            if (result == null) {
                result = Source.fromFile(new File(name), StandardCharsets.UTF_8);
            }
            assert (result != null);
            this.sourceCache.put(name, result);
        }
        return result;
    }

    private InputStream load(String name) throws IOException {
        Source src = this.getSource(name, null);
        String code = this.codeCache.get(src);
        if (code == null) {
            code = this.compiler.compile(name, this);
            this.codeCache.put(src, code);
        }
        return new ByteArrayInputStream(code.getBytes(StandardCharsets.UTF_8));
    }
}

