/// <reference path="./throwable.d.ts" />
/// <reference path="write_stream.d.ts" />

declare module "vertx-js/message_producer" {
  export = MessageProducer;
}

/**
 * Represents a stream of message that can be written to.
 * <p>
 */
interface MessageProducer
  extends
    WriteStream
{

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using setWriteQueueMaxSize
   */
  writeQueueFull(): boolean;
  exceptionHandler(handler: (e: Throwable) => void): MessageProducer;
  write(data: any): MessageProducer;
  setWriteQueueMaxSize(maxSize: number): MessageProducer;
  drainHandler(handler: (e: void) => void): MessageProducer;

  /**
   * Update the delivery options of this producer.
   */
  deliveryOptions(options: any): MessageProducer;

  /**
   * @return The address to which the producer produces messages.
   */
  address(): string;
}

declare var MessageProducer: {
  new(): MessageProducer;
}
