/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.gradle.api.logging.Logger;

public class ProgressLoggerWrapper {
    private final Logger logger;
    private Object progressLogger;
    private String size;
    private String destFileName;
    private long processedBytes = 0L;
    private long loggedKb = 0L;

    public ProgressLoggerWrapper(Logger logger) {
        this.logger = logger;
    }

    public void init(Object servicesOwner, String src) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> progressLoggerFactoryClass = Class.forName("org.gradle.internal.logging.progress.ProgressLoggerFactory");
        Object serviceFactory = ProgressLoggerWrapper.invoke(servicesOwner, "getServices", new Object[0]);
        Object progressLoggerFactory = ProgressLoggerWrapper.invoke(serviceFactory, "get", progressLoggerFactoryClass);
        this.progressLogger = ProgressLoggerWrapper.invoke(progressLoggerFactory, "newOperation", this.getClass());
        String desc = "Download " + src;
        ProgressLoggerWrapper.invoke(this.progressLogger, "setDescription", desc);
        try {
            ProgressLoggerWrapper.invoke(this.progressLogger, "setLoggingHeader", desc);
        }
        catch (ReflectiveOperationException e) {
            this.logger.lifecycle(desc);
        }
    }

    private static Object invoke(Object obj, String method, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class[] argumentTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argumentTypes[i] = args[i].getClass();
        }
        Method m = ProgressLoggerWrapper.findMethod(obj, method, argumentTypes);
        m.setAccessible(true);
        return m.invoke(obj, args);
    }

    private static Method findMethod(Object obj, String methodName, Class<?>[] argumentTypes) throws NoSuchMethodException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), argumentTypes)) continue;
                return method;
            }
        }
        throw new NoSuchMethodException("Method " + methodName + "(" + Arrays.toString(argumentTypes) + ") on " + obj.getClass());
    }

    private void invokeIgnoreExceptions(Object obj, String method, Object ... args) {
        try {
            ProgressLoggerWrapper.invoke(obj, method, args);
        }
        catch (ReflectiveOperationException e) {
            this.logger.trace("Unable to log progress", (Throwable)e);
        }
    }

    public void started() {
        if (this.progressLogger != null) {
            this.invokeIgnoreExceptions(this.progressLogger, "started", new Object[0]);
        }
    }

    public void completed() {
        if (this.progressLogger != null) {
            this.invokeIgnoreExceptions(this.progressLogger, "completed", new Object[0]);
        }
    }

    private void progress(String msg) {
        if (this.progressLogger != null) {
            this.invokeIgnoreExceptions(this.progressLogger, "progress", msg);
        }
    }

    public void setSize(long size) {
        this.size = ProgressLoggerWrapper.toLengthText(size);
        this.processedBytes = 0L;
        this.loggedKb = 0L;
    }

    public void setDestFileName(String destFileName) {
        this.destFileName = destFileName;
    }

    public void incrementProgress(long increment) {
        this.processedBytes += increment;
        if (this.progressLogger == null) {
            return;
        }
        long processedKb = this.processedBytes / 1024L;
        if (processedKb > this.loggedKb) {
            StringBuilder sb = new StringBuilder();
            if (this.destFileName != null) {
                sb.append(this.destFileName);
                sb.append(" > ");
            }
            sb.append(ProgressLoggerWrapper.toLengthText(this.processedBytes));
            if (this.size != null) {
                sb.append("/");
                sb.append(this.size);
            }
            sb.append(" downloaded");
            this.progress(sb.toString());
            this.loggedKb = processedKb;
        }
    }

    private static String toLengthText(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }
}

