/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download;

import de.undercouch.gradle.tasks.download.DownloadSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tools.ant.util.Base64Converter;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class DownloadAction
implements DownloadSpec {
    private URL src;
    private File dest;
    private boolean quiet = false;
    private boolean overwrite = true;
    private boolean onlyIfNewer = false;
    private String username;
    private String password;
    private ProgressLogger progressLogger;
    private String size;
    private long processedBytes = 0L;
    private long loggedKb = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Project project) throws IOException {
        URLConnection conn;
        File destFile;
        if (this.src == null) {
            throw new IllegalArgumentException("Please provide a download source");
        }
        if (this.dest == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        if (this.dest.equals(project.getBuildDir())) {
            this.dest.mkdirs();
        }
        if ((destFile = this.dest).isDirectory()) {
            String name = this.src.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.substring(name.lastIndexOf(47) + 1);
            destFile = new File(this.dest, name);
        } else {
            File parent = destFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
        }
        if (!this.overwrite && destFile.exists()) {
            if (!this.quiet) {
                project.getLogger().info("Destination file already exists. Skipping '" + destFile.getName() + "'");
            }
            return;
        }
        long timestamp = 0L;
        if (this.onlyIfNewer && destFile.exists()) {
            timestamp = destFile.lastModified();
        }
        if (!this.quiet && project instanceof ProjectInternal) {
            ProjectInternal pi = (ProjectInternal)project;
            ProgressLoggerFactory plf = (ProgressLoggerFactory)pi.getServices().get(ProgressLoggerFactory.class);
            this.progressLogger = plf.newOperation(this.getClass());
            String desc = "Download " + this.src.toString();
            this.progressLogger.setDescription(desc);
            this.progressLogger.setLoggingHeader(desc);
        }
        if ((conn = this.openConnection(timestamp, project)) == null) {
            return;
        }
        long contentLength = this.parseContentLength(conn);
        if (contentLength >= 0L) {
            this.size = this.toLengthText(contentLength);
        }
        InputStream is = conn.getInputStream();
        try {
            this.startProgress();
            FileOutputStream os = new FileOutputStream(destFile);
            boolean finished = false;
            try {
                int read;
                byte[] buf = new byte[10240];
                while ((read = is.read(buf)) >= 0) {
                    ((OutputStream)os).write(buf, 0, read);
                    this.processedBytes += (long)read;
                    this.logProgress();
                }
                os.flush();
                finished = true;
            }
            finally {
                ((OutputStream)os).close();
                if (!finished) {
                    destFile.delete();
                }
            }
        }
        finally {
            is.close();
            this.completeProgress();
        }
        long newTimestamp = conn.getLastModified();
        if (this.onlyIfNewer && newTimestamp > 0L) {
            destFile.setLastModified(newTimestamp);
        }
    }

    private URLConnection openConnection(long timestamp, Project project) throws IOException {
        URLConnection uc = this.src.openConnection();
        if (timestamp > 0L) {
            uc.setIfModifiedSince(timestamp);
        }
        if (this.username != null && this.password != null) {
            String up = this.username + ":" + this.password;
            Base64Converter encoder = new Base64Converter();
            String encoding = encoder.encode(up.getBytes());
            uc.setRequestProperty("Authorization", "Basic " + encoding);
        }
        uc.connect();
        if (uc instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)uc;
            int responseCode = httpConnection.getResponseCode();
            long lastModified = httpConnection.getLastModified();
            if (responseCode == 304 || lastModified != 0L && timestamp >= lastModified) {
                if (!this.quiet) {
                    project.getLogger().info("Not modified. Skipping '" + this.src + "'");
                }
                return null;
            }
        }
        return uc;
    }

    private String toLengthText(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    private long parseContentLength(URLConnection conn) {
        String value = conn.getHeaderField("Content-Length");
        if (value == null || value.isEmpty()) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private void startProgress() {
        if (this.progressLogger != null) {
            this.progressLogger.started();
        }
    }

    private void completeProgress() {
        if (this.progressLogger != null) {
            this.progressLogger.completed();
        }
    }

    private void logProgress() {
        if (this.progressLogger == null) {
            return;
        }
        long processedKb = this.processedBytes / 1024L;
        if (processedKb > this.loggedKb) {
            String msg = this.toLengthText(this.processedBytes);
            if (this.size != null) {
                msg = msg + "/" + this.size;
            }
            msg = msg + " downloaded";
            this.progressLogger.progress(msg);
            this.loggedKb = processedKb;
        }
    }

    @Override
    public void src(Object src) throws MalformedURLException {
        if (src instanceof String) {
            this.src = new URL((String)src);
        } else if (src instanceof URL) {
            this.src = (URL)src;
        } else {
            throw new IllegalArgumentException("Download source must either be a URL or a String");
        }
    }

    @Override
    public void dest(Object dest) {
        if (dest instanceof String) {
            this.dest = new File((String)dest);
        } else if (dest instanceof File) {
            this.dest = (File)dest;
        } else {
            throw new IllegalArgumentException("Download destination must either be a File or a String");
        }
    }

    @Override
    public void quiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.onlyIfNewer = onlyIfNewer;
    }

    @Override
    public void username(String username) {
        this.username = username;
    }

    @Override
    public void password(String password) {
        this.password = password;
    }

    @Override
    public URL getSrc() {
        return this.src;
    }

    @Override
    public File getDest() {
        return this.dest;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean isOnlyIfNewer() {
        return this.onlyIfNewer;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }
}

