/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringHelper {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String TITLECASE_STOPWORD_FOLLOWEDBY = "[^\\p{L}\\d_:'\"\u2018\u2019\u201c\u201d]+";
    private static final Pattern[] TITLECASE_STOPWORD_PATTERNS;
    private static final Pattern WORD_PATTERN;
    private static final Pattern MAIL_PATTERN;
    private static final String TLDs = "(com|net|org|edu|gov|mil|aero|asia|biz|cat|coop|info|int|jobs|mobi|museum|name|post|pro|tel|travel|xxx|ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cs|cu|cv|cx|cy|cz|dd|de|dj|dk|dm|do|dz|ec|ee|eg|eh|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|Ja|sk|sl|sm|sn|so|sr|ss|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw)";
    private static final Pattern URL_PATTERN;
    private static final Pattern POSSESSIVE_S_PATTERN;

    public static String sanitize(String s) {
        StringBuilder sb = new StringBuilder();
        block21: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u00c0': 
                case '\u00c1': 
                case '\u00c3': 
                case '\u00c4': {
                    sb.append('A');
                    continue block21;
                }
                case '\u00c8': 
                case '\u00c9': 
                case '\u00cb': {
                    sb.append('E');
                    continue block21;
                }
                case '\u00cc': 
                case '\u00cd': 
                case '\u00cf': {
                    sb.append('I');
                    continue block21;
                }
                case '\u00d2': 
                case '\u00d3': 
                case '\u00d5': 
                case '\u00d6': {
                    sb.append('O');
                    continue block21;
                }
                case '\u00d9': 
                case '\u00da': 
                case '\u00dc': {
                    sb.append('U');
                    continue block21;
                }
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e3': 
                case '\u00e4': {
                    sb.append('a');
                    continue block21;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00eb': {
                    sb.append('e');
                    continue block21;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ef': {
                    sb.append('i');
                    continue block21;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f5': 
                case '\u00f6': {
                    sb.append('o');
                    continue block21;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fc': {
                    sb.append('u');
                    continue block21;
                }
                case '\u00d1': {
                    sb.append('N');
                    continue block21;
                }
                case '\u00f1': {
                    sb.append('n');
                    continue block21;
                }
                case '\u010c': {
                    sb.append('C');
                    continue block21;
                }
                case '\u0160': {
                    sb.append('S');
                    continue block21;
                }
                case '\u017d': {
                    sb.append('Z');
                    continue block21;
                }
                case '\u010d': {
                    sb.append('c');
                    continue block21;
                }
                case '\u0161': {
                    sb.append('s');
                    continue block21;
                }
                case '\u017e': {
                    sb.append('z');
                    continue block21;
                }
                case '\u00df': {
                    sb.append("ss");
                    continue block21;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        sb.append(c);
                        continue block21;
                    }
                    sb.append('_');
                }
            }
        }
        return sb.toString();
    }

    public static String escapeJava(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(Math.min(2, s.length() * 3 / 2));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                sb.append("\\u");
                sb.append(StringHelper.hex4(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String hex4(char c) {
        char[] r = new char[]{'0', '0', '0', '0'};
        int i = 3;
        while (c > '\u0000') {
            r[i] = HEX_DIGITS[c & 0xF];
            c = (char)(c >>> 4);
            --i;
        }
        return new String(r);
    }

    public static int overlap(CharSequence a, CharSequence b) {
        int start;
        if (a == null || b == null || a.length() == 0 || b.length() == 0) {
            return 0;
        }
        for (int i = start = Math.max(0, a.length() - b.length()); i < a.length(); ++i) {
            int j;
            for (j = 0; j < b.length() && i + j < a.length() && a.charAt(i + j) == b.charAt(j); ++j) {
            }
            if (i + j != a.length()) continue;
            return j;
        }
        return 0;
    }

    private static boolean isAllUppercase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    private static boolean titleAllUppercase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldCapitalize(String s) {
        if (s.length() == 1 && s.charAt(0) >= '\u0370' && s.charAt(0) <= '\u03ff') {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldStopwordLowercase(String w, String str) {
        if (w.equalsIgnoreCase("d'") || w.equalsIgnoreCase("d\u2019")) {
            Matcher wm = WORD_PATTERN.matcher(str.substring(2));
            return !wm.find() || !StringHelper.titleAllUppercase(str.substring(2, wm.end() + 2));
        }
        return !StringHelper.titleAllUppercase(w);
    }

    public static String toTitleCase(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (StringHelper.titleAllUppercase(str)) {
            str = str.toLowerCase(Locale.ENGLISH);
        }
        StringBuilder sb = new StringBuilder();
        int nwords = 0;
        int i = 0;
        while (i < str.length()) {
            Matcher pm;
            String ss = str.substring(i);
            int swe = -1;
            if (i > 0 && nwords > 0) {
                char prevChar = str.charAt(i - 1);
                for (Pattern p : TITLECASE_STOPWORD_PATTERNS) {
                    Matcher m = p.matcher(ss);
                    if (!m.find() || ss.charAt(m.end() - 1) == '-' && prevChar != '-') continue;
                    swe = m.end();
                    break;
                }
            }
            if (swe >= 0) {
                String w = ss.substring(0, swe);
                if (StringHelper.shouldStopwordLowercase(w, ss)) {
                    sb.append(w.toLowerCase(Locale.ENGLISH));
                } else {
                    sb.append(w);
                }
                i += swe;
                ++nwords;
                continue;
            }
            if (i > 0 && Character.isLetterOrDigit(str.charAt(i - 1)) && (pm = POSSESSIVE_S_PATTERN.matcher(ss)).find()) {
                sb.append(ss.substring(0, pm.end()).toLowerCase(Locale.ENGLISH));
                i += pm.end();
                ++nwords;
                continue;
            }
            Matcher mam = MAIL_PATTERN.matcher(ss);
            if (mam.find()) {
                sb.append(ss, 0, mam.end());
                i += mam.end();
                ++nwords;
                continue;
            }
            Matcher um = URL_PATTERN.matcher(ss);
            if (um.find()) {
                sb.append(ss, 0, um.end());
                i += um.end();
                ++nwords;
                continue;
            }
            Matcher wm = WORD_PATTERN.matcher(ss);
            if (wm.find()) {
                String w = ss.substring(0, wm.end());
                if (StringHelper.shouldCapitalize(w)) {
                    w = Character.toTitleCase(w.charAt(0)) + w.substring(1);
                }
                sb.append(w);
                i += wm.end();
                ++nwords;
                continue;
            }
            char c = str.charAt(i);
            if (c == ':' || c == '.' || c == '\u201c' || c == '\u2018') {
                nwords = 0;
            }
            boolean maybeNewSentence = c == '\"' || c == '\'';
            sb.append(c);
            ++i;
            boolean foundWhitespace = false;
            while (i < str.length() && Character.isWhitespace(c = str.charAt(i))) {
                sb.append(c);
                foundWhitespace = true;
                ++i;
            }
            if (!maybeNewSentence || foundWhitespace) continue;
            nwords = 0;
        }
        return sb.toString();
    }

    public static String initializeName(String name, String initializeWith) {
        return StringHelper.initializeName(name, initializeWith, false);
    }

    public static String initializeName(String name, String initializeWith, boolean onlyNormalize) {
        name = name.trim().replaceAll("\\s+", " ").replaceAll("\\s*\\.", ".").replaceAll("\\.+", ".").replaceAll("\\s*[-\u2010\u2011\u2012\u2013\u2014\u2015]+\\s*", "-");
        ArrayList<NamePart> parts = new ArrayList<NamePart>();
        int lp = 0;
        for (int i = 1; i <= name.length(); ++i) {
            String sub;
            if (i == name.length() || name.charAt(i) == ' ') {
                if (i > lp) {
                    parts.add(new NamePart(sub, false, (sub = name.substring(lp, i)).length() == 1 && StringHelper.isAllUppercase(sub)));
                }
                lp = i + 1;
                continue;
            }
            if (name.charAt(i) == '-') {
                if (i > lp) {
                    parts.add(new NamePart(sub, true, (sub = name.substring(lp, i)).length() == 1 && StringHelper.isAllUppercase(sub)));
                }
                lp = i + 1;
                continue;
            }
            if (name.charAt(i) == '.' && i < name.length() - 1 && name.charAt(i + 1) == '-') {
                if (i > lp) {
                    parts.add(new NamePart(name.substring(lp, i), true, true));
                }
                lp = ++i + 1;
                continue;
            }
            if (name.charAt(i) != '.') continue;
            if (i > lp) {
                parts.add(new NamePart(name.substring(lp, i), false, true));
            }
            lp = i + 1;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            NamePart p = (NamePart)parts.get(i);
            if (!(!onlyNormalize || i <= 0 || p.alreadyInitialized && ((NamePart)parts.get((int)(i - 1))).alreadyInitialized || result.length() <= 0 || result.charAt(result.length() - 1) == ' ' || result.charAt(result.length() - 1) == '-')) {
                result.append(" ");
            }
            if (onlyNormalize || p.alreadyInitialized) {
                result.append(p.part);
            } else {
                result.append(p.part.charAt(0));
            }
            if (!onlyNormalize || p.alreadyInitialized) {
                result.append(initializeWith);
            }
            if (!p.hyphen) continue;
            result.append("-");
        }
        return result.toString().replaceAll("\\s+-", "-").trim();
    }

    static {
        String p = TITLECASE_STOPWORD_FOLLOWEDBY;
        String[] stopwords = new String[]{"^a" + p, "^according\\s+to" + p, "^across" + p, "^afore" + p, "^after" + p, "^against" + p, "^ahead\\s+of" + p, "^along" + p, "^alongside" + p, "^amid" + p, "^amidst" + p, "^among" + p, "^amongst" + p, "^an" + p, "^and" + p, "^anenst" + p, "^apart\\s+from" + p, "^apropos" + p, "^apud" + p, "^around" + p, "^as" + p, "^as\\s+regards" + p, "^aside" + p, "^astride" + p, "^at" + p, "^athwart" + p, "^atop" + p, "^back\\s+to" + p, "^barring" + p, "^because\\s+of" + p, "^before" + p, "^behind" + p, "^below" + p, "^beneath" + p, "^beside" + p, "^besides" + p, "^between" + p, "^beyond" + p, "^but" + p, "^by" + p, "^c" + p, "^ca" + p, "^circa" + p, "^close\\s+to" + p, "^d['\u2019](?=\\p{L})", "^de" + p, "^despite" + p, "^down" + p, "^due\\s+to" + p, "^during" + p, "^et" + p, "^except" + p, "^far\\s+from" + p, "^for" + p, "^forenenst" + p, "^from" + p, "^given" + p, "^in" + p, "^inside" + p, "^instead\\s+of" + p, "^into" + p, "^lest" + p, "^like" + p, "^modulo" + p, "^near" + p, "^next" + p, "^nor" + p, "^notwithstanding" + p, "^of" + p, "^off" + p, "^on" + p, "^onto" + p, "^or" + p, "^out" + p, "^outside\\s+of" + p, "^over" + p, "^per" + p, "^plus" + p, "^prior\\s+to" + p, "^pro" + p, "^pursuant\\s+to" + p, "^qua" + p, "^rather\\s+than" + p, "^regardless\\s+of" + p, "^sans" + p, "^since" + p, "^so" + p, "^such\\s+as" + p, "^than" + p, "^that\\s+of" + p, "^the" + p, "^through" + p, "^throughout" + p, "^thru" + p, "^thruout" + p, "^till" + p, "^to" + p, "^toward" + p, "^towards" + p, "^under" + p, "^underneath" + p, "^until" + p, "^unto" + p, "^up" + p, "^upon" + p, "^v\\." + p, "^van" + p, "^versus" + p, "^via" + p, "^vis-\u00e0-vis" + p, "^von" + p, "^vs\\." + p, "^where\\s+as" + p, "^with" + p, "^within" + p, "^without" + p, "^yet" + p};
        Arrays.sort(stopwords, Comparator.comparingInt(String::length).reversed());
        TITLECASE_STOPWORD_PATTERNS = new Pattern[stopwords.length];
        for (int i = 0; i < stopwords.length; ++i) {
            StringHelper.TITLECASE_STOPWORD_PATTERNS[i] = Pattern.compile(stopwords[i], 2);
        }
        WORD_PATTERN = Pattern.compile("^[\\p{L}\\d][\\p{L}\\d\\[\\]()'\u2019&]*");
        MAIL_PATTERN = Pattern.compile("^(mailto:)?([\\w.-]+@[a-z0-9-]+(\\.[a-z0-9-]+)*\\.[a-z]+)", 2);
        URL_PATTERN = Pattern.compile("^((?:https?:(?:/{1,3}|[a-z0-9%])|[a-z0-9.\\-]+[.](com|net|org|edu|gov|mil|aero|asia|biz|cat|coop|info|int|jobs|mobi|museum|name|post|pro|tel|travel|xxx|ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cs|cu|cv|cx|cy|cz|dd|de|dj|dk|dm|do|dz|ec|ee|eg|eh|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|Ja|sk|sl|sm|sn|so|sr|ss|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw)/)(?:[^\\s()<>{}\\[\\]]+|\\([^\\s()]*?\\([^\\s()]+\\)[^\\s()]*?\\)|\\(\\S+?\\))+(?:\\([^\\s()]*?\\([^\\s()]+\\)[^\\s()]*?\\)|\\(\\S+?\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019])|(?<!@)[a-z0-9]+(?:[.\\-][a-z0-9]+)*[.](com|net|org|edu|gov|mil|aero|asia|biz|cat|coop|info|int|jobs|mobi|museum|name|post|pro|tel|travel|xxx|ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cs|cu|cv|cx|cy|cz|dd|de|dj|dk|dm|do|dz|ec|ee|eg|eh|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|Ja|sk|sl|sm|sn|so|sr|ss|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw)\\b/?(?!@))", 2);
        POSSESSIVE_S_PATTERN = Pattern.compile("^['\u2019]s[^\\p{L}\\d_:'\"\u2018\u2019\u201c\u201d]+", 2);
    }

    private static class NamePart {
        final String part;
        final boolean hyphen;
        final boolean alreadyInitialized;

        NamePart(String part, boolean hyphen, boolean alreadyInitialized) {
            this.part = part;
            this.hyphen = hyphen;
            this.alreadyInitialized = alreadyInitialized;
        }
    }
}

