/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SElement;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.behavior.TextCase;
import de.undercouch.citeproc.csl.internal.rendering.SNameInheritableAttributes;
import de.undercouch.citeproc.helper.NodeHelper;
import de.undercouch.citeproc.helper.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SName
implements SElement {
    public static final int FORM_LONG = 0;
    public static final int FORM_SHORT = 1;
    public static final int FORM_COUNT = 2;
    private final String variable;
    private final String delimiter;
    private final int form;
    private final int formattingAttributes;
    private final SNameInheritableAttributes inheritableAttributes;
    private final int familyFormattingAttributes;
    private final int givenFormattingAttributes;
    private final Affixes familyAffixes;
    private final Affixes givenAffixes;
    private final TextCase familyTextCase;
    private final TextCase givenTextCase;

    public SName(Node node, String variable) {
        String form;
        String delimiter;
        this.variable = variable;
        this.inheritableAttributes = new SNameInheritableAttributes(node);
        boolean namePartFamilyParsed = false;
        boolean namePartGivenParsed = false;
        int familyFormattingAttributes = 0;
        int givenFormattingAttributes = 0;
        Affixes familyAffixes = new Affixes();
        Affixes givenAffixes = new Affixes();
        TextCase familyTextCase = null;
        TextCase givenTextCase = null;
        if (node != null) {
            this.formattingAttributes = FormattingAttributes.of(node);
            delimiter = NodeHelper.getAttrValue(node, "delimiter");
            form = NodeHelper.getAttrValue(node, "form");
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node c = children.item(i);
                String nodeName = c.getNodeName();
                if (!"name-part".equals(nodeName)) continue;
                String namePartName = NodeHelper.getAttrValue(c, "name");
                if (namePartName == null) {
                    throw new IllegalStateException("Missing name part name");
                }
                if (namePartName.equals("family")) {
                    if (!namePartFamilyParsed) {
                        familyFormattingAttributes = FormattingAttributes.of(c);
                        familyAffixes = new Affixes(c);
                        familyTextCase = new TextCase(c);
                        namePartFamilyParsed = true;
                        continue;
                    }
                    throw new IllegalStateException("Duplicate name part name: family");
                }
                if (namePartName.equals("given")) {
                    if (!namePartGivenParsed) {
                        givenFormattingAttributes = FormattingAttributes.of(c);
                        givenAffixes = new Affixes(c);
                        givenTextCase = new TextCase(c);
                        namePartGivenParsed = true;
                        continue;
                    }
                    throw new IllegalStateException("Duplicate name part name: given");
                }
                throw new IllegalStateException("Unknown name part name: " + namePartName);
            }
        } else {
            this.formattingAttributes = 0;
            delimiter = null;
            form = null;
        }
        if (delimiter == null) {
            delimiter = ", ";
        }
        this.delimiter = delimiter;
        this.form = "count".equals(form) ? 2 : ("short".equals(form) ? 1 : 0);
        this.familyFormattingAttributes = familyFormattingAttributes;
        this.givenFormattingAttributes = givenFormattingAttributes;
        this.familyAffixes = familyAffixes;
        this.givenAffixes = givenAffixes;
        this.familyTextCase = familyTextCase;
        this.givenTextCase = givenTextCase;
    }

    public String getVariable() {
        return this.variable;
    }

    public int getForm() {
        return this.form;
    }

    @Override
    public void render(RenderContext ctx) {
        ArrayList<CSLName> names = new ArrayList<CSLName>();
        if (this.variable != null) {
            String[] variables;
            for (String v : variables = this.variable.split("\\s+")) {
                CSLName[] vn = ctx.getNameVariable(v);
                if (vn == null) continue;
                names.addAll(Arrays.asList(vn));
            }
        }
        if (names.isEmpty()) {
            return;
        }
        SNameInheritableAttributes ia = ctx.getInheritedNameAttributes().merge(this.inheritableAttributes);
        String and = ia.getAnd();
        Integer etAlMin = ia.getEtAlMin();
        Integer etAlUseFirst = ia.getEtAlUseFirst();
        String nameAsSortOrder = ia.getNameAsSortOrder();
        String delimiterPrecedesEtAl = ia.getDelimiterPrecedesEtAl();
        String delimiterPrecedesLast = ia.getDelimiterPrecedesLast();
        String initializeWith = ia.getInitializeWith();
        boolean initialize = ia.isInitialize();
        String sortSeparator = ia.getSortSeparator();
        String renderedAnd = "text".equals(and) ? " " + ctx.getTerm("and") + " " : ("symbol".equals(and) ? " & " : this.delimiter);
        int max = -1;
        if (etAlMin != null && etAlUseFirst != null && names.size() >= etAlMin && (max = etAlUseFirst.intValue()) == 0) {
            return;
        }
        if (this.form == 2) {
            int count = names.size();
            if (max > -1 && max < count) {
                count = max;
            }
            ctx.emit(String.valueOf(count), this.formattingAttributes);
            return;
        }
        TokenBuffer buffer = new TokenBuffer();
        for (int i = 0; i < names.size(); ++i) {
            boolean nameAsSort = "all".equals(nameAsSortOrder) || i == 0 && "first".equals(nameAsSortOrder);
            buffer.append(this.render((CSLName)names.get(i), nameAsSort, initializeWith, initialize, sortSeparator, ctx));
            if (i >= names.size() - 1) continue;
            if (i == max - 1) {
                String etAl = ctx.getTerm("et-al");
                this.appendDelimiter(buffer, delimiterPrecedesEtAl, nameAsSort, max > 1);
                buffer.append(" " + etAl, Token.Type.SUFFIX);
                break;
            }
            if (i == names.size() - 2) {
                boolean delimiterAppended = this.appendDelimiter(buffer, delimiterPrecedesLast, nameAsSort, names.size() > 2);
                if (delimiterAppended && renderedAnd.equals(this.delimiter)) continue;
                buffer.append(renderedAnd, Token.Type.DELIMITER);
                continue;
            }
            buffer.append(this.delimiter, Token.Type.DELIMITER);
        }
        ctx.emit(buffer, this.formattingAttributes);
    }

    private boolean appendDelimiter(TokenBuffer buffer, String delimiterPrecedes, boolean nameAsSort, boolean contextual) {
        boolean delimiterAppended = false;
        switch (delimiterPrecedes) {
            case "contextual": {
                if (!contextual) break;
                buffer.append(this.delimiter, Token.Type.DELIMITER);
                delimiterAppended = true;
                break;
            }
            case "always": {
                buffer.append(this.delimiter, Token.Type.DELIMITER);
                delimiterAppended = true;
                break;
            }
            case "after-inverted-name": {
                if (!nameAsSort) break;
                buffer.append(this.delimiter, Token.Type.DELIMITER);
                delimiterAppended = true;
                break;
            }
        }
        return delimiterAppended;
    }

    private TokenBuffer render(CSLName name, boolean nameAsSort, String initializeWith, boolean initialize, String sortSeparator, RenderContext ctx) {
        if (name.getLiteral() != null) {
            return new TokenBuffer().append(name.getLiteral(), Token.Type.TEXT);
        }
        String strFamily = name.getFamily();
        TokenBuffer family = new TokenBuffer();
        if (strFamily != null) {
            if (this.familyTextCase != null) {
                strFamily = this.familyTextCase.applyTo(strFamily, ctx);
            }
            family.append(strFamily, Token.Type.TEXT, this.familyFormattingAttributes);
            if (name.getNonDroppingParticle() != null) {
                family.prepend(" ", Token.Type.DELIMITER);
                String ndp = name.getNonDroppingParticle().trim();
                if (this.familyTextCase != null) {
                    ndp = this.familyTextCase.applyTo(ndp, ctx);
                }
                family.prepend(ndp, Token.Type.TEXT, this.familyFormattingAttributes);
            }
            if (this.form == 1) {
                return family;
            }
            if (name.getDroppingParticle() != null) {
                family.prepend(" ", Token.Type.DELIMITER);
                String dp = name.getDroppingParticle().trim();
                if (this.givenTextCase != null) {
                    dp = this.givenTextCase.applyTo(dp, ctx);
                }
                family.prepend(dp, Token.Type.TEXT, this.givenFormattingAttributes);
            }
            if (name.getSuffix() != null) {
                family.append(" ", Token.Type.DELIMITER);
                family.append(name.getSuffix().trim(), Token.Type.TEXT);
            }
        }
        this.familyAffixes.applyTo(family);
        String strGiven = name.getGiven();
        if (initializeWith != null && !family.isEmpty() && strGiven != null) {
            strGiven = StringHelper.initializeName(strGiven, initializeWith, !initialize);
        }
        TokenBuffer given = new TokenBuffer();
        if (strGiven != null) {
            if (this.givenTextCase != null) {
                strGiven = this.givenTextCase.applyTo(strGiven, ctx);
            }
            given.append(strGiven, Token.Type.TEXT, this.givenFormattingAttributes);
        }
        this.givenAffixes.applyTo(given);
        TokenBuffer result = new TokenBuffer();
        if (nameAsSort) {
            result.append(family);
            if (!family.isEmpty() && !given.isEmpty()) {
                result.append(sortSeparator, Token.Type.DELIMITER);
            }
            result.append(given);
        } else {
            result.append(given);
            if (!given.isEmpty() && !family.isEmpty()) {
                result.append(" ", Token.Type.DELIMITER);
            }
            result.append(family);
        }
        return result;
    }
}

