/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.locale;

import de.undercouch.citeproc.csl.internal.locale.LDate;
import de.undercouch.citeproc.csl.internal.locale.LStyleOptions;
import de.undercouch.citeproc.csl.internal.locale.LTerm;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LLocale {
    private final Locale lang;
    private final Map<String, LDate> dateFormats;
    private final Map<LTerm.Form, Map<String, LTerm>> terms;
    private final LStyleOptions styleOptions;

    public LLocale(Document localeDocument) {
        this(localeDocument.getDocumentElement());
    }

    public LLocale(Node localeRoot) {
        String strLang = NodeHelper.getAttrValue(localeRoot, "xml:lang");
        this.lang = strLang == null ? null : Locale.forLanguageTag(strLang);
        this.dateFormats = new HashMap<String, LDate>();
        this.terms = new HashMap<LTerm.Form, Map<String, LTerm>>();
        LStyleOptions styleOptions = null;
        NodeList children = localeRoot.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if ("terms".equals(c.getNodeName())) {
                NodeList termsNodeChildren = c.getChildNodes();
                for (int j = 0; j < termsNodeChildren.getLength(); ++j) {
                    Node tc = termsNodeChildren.item(j);
                    if (!"term".equals(tc.getNodeName())) continue;
                    LTerm t = new LTerm(tc);
                    Map m = this.terms.computeIfAbsent(t.getForm(), k -> new HashMap());
                    m.put(t.getName(), t);
                }
                continue;
            }
            if ("style-options".equals(c.getNodeName())) {
                styleOptions = new LStyleOptions(c);
                continue;
            }
            if (!"date".equals(c.getNodeName())) continue;
            LDate d = new LDate(c);
            this.dateFormats.put(d.getForm(), d);
        }
        this.styleOptions = styleOptions;
    }

    private LLocale(Locale lang, Map<String, LDate> dateFormats, Map<LTerm.Form, Map<String, LTerm>> terms, LStyleOptions styleOptions) {
        this.lang = lang;
        this.dateFormats = dateFormats;
        this.terms = terms;
        this.styleOptions = styleOptions;
    }

    public LLocale merge(LLocale other) {
        LStyleOptions styleOptions = this.styleOptions;
        if (other.styleOptions != null) {
            styleOptions = other.styleOptions;
        }
        HashMap<String, LDate> dateFormats = new HashMap<String, LDate>(this.dateFormats);
        if (other.dateFormats != null) {
            dateFormats.putAll(other.dateFormats);
        }
        HashMap<LTerm.Form, Map<String, LTerm>> terms = new HashMap<LTerm.Form, Map<String, LTerm>>(this.terms);
        if (other.terms != null) {
            for (Map.Entry<LTerm.Form, Map<String, LTerm>> e : other.terms.entrySet()) {
                terms.merge(e.getKey(), e.getValue(), (a, b) -> {
                    a.putAll(b);
                    return a;
                });
            }
        }
        return new LLocale(this.lang, dateFormats, terms, styleOptions);
    }

    public Locale getLang() {
        return this.lang;
    }

    public Map<String, LDate> getDateFormats() {
        return this.dateFormats;
    }

    public Map<LTerm.Form, Map<String, LTerm>> getTerms() {
        return this.terms;
    }

    public LStyleOptions getStyleOptions() {
        if (this.styleOptions == null) {
            return LStyleOptions.DEFAULT;
        }
        return this.styleOptions;
    }
}

