/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.behavior;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.behavior.Behavior;
import de.undercouch.citeproc.helper.NodeHelper;
import de.undercouch.citeproc.helper.StringHelper;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.w3c.dom.Node;

public class TextCase
implements Behavior {
    private final String textCase;

    public TextCase(Node node) {
        this.textCase = NodeHelper.getAttrValue(node, "text-case");
    }

    @Override
    public void accept(Consumer<RenderContext> renderFunction, RenderContext ctx) {
        RenderContext child = new RenderContext(ctx);
        renderFunction.accept(child);
        child.getResult().getTokens().stream().map(t -> this.transform((Token)t, ctx)).forEach(ctx::emit);
    }

    private Token transform(Token t, RenderContext ctx) {
        return new Token.Builder(t).text(this.applyTo(t.getText(), ctx)).build();
    }

    public String applyTo(String s, RenderContext ctx) {
        if ("lowercase".equals(this.textCase)) {
            s = s.toLowerCase();
        } else if ("uppercase".equals(this.textCase)) {
            s = s.toUpperCase();
        } else if ("capitalize-first".equals(this.textCase)) {
            s = StringUtils.capitalize((String)s);
        } else if ("capitalize-all".equals(this.textCase)) {
            s = WordUtils.capitalize((String)s);
        } else if ("title".equals(this.textCase) && ctx.getItemLocale().getLanguage().equals("en")) {
            s = StringHelper.toTitleCase(s);
        }
        return s;
    }
}

