/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import java.util.ArrayList;
import java.util.List;

public class StringHelper {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] TITLECASE_STOPWORDS = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "in", "into", "nor", "of", "on", "onto", "or", "over", "so", "the", "till", "to", "up", "via", "with", "without", "yet"};

    public static String sanitize(String s) {
        StringBuilder sb = new StringBuilder();
        block21: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u00c0': 
                case '\u00c1': 
                case '\u00c3': 
                case '\u00c4': {
                    sb.append('A');
                    continue block21;
                }
                case '\u00c8': 
                case '\u00c9': 
                case '\u00cb': {
                    sb.append('E');
                    continue block21;
                }
                case '\u00cc': 
                case '\u00cd': 
                case '\u00cf': {
                    sb.append('I');
                    continue block21;
                }
                case '\u00d2': 
                case '\u00d3': 
                case '\u00d5': 
                case '\u00d6': {
                    sb.append('O');
                    continue block21;
                }
                case '\u00d9': 
                case '\u00da': 
                case '\u00dc': {
                    sb.append('U');
                    continue block21;
                }
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e3': 
                case '\u00e4': {
                    sb.append('a');
                    continue block21;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00eb': {
                    sb.append('e');
                    continue block21;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ef': {
                    sb.append('i');
                    continue block21;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f5': 
                case '\u00f6': {
                    sb.append('o');
                    continue block21;
                }
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fc': {
                    sb.append('u');
                    continue block21;
                }
                case '\u00d1': {
                    sb.append('N');
                    continue block21;
                }
                case '\u00f1': {
                    sb.append('n');
                    continue block21;
                }
                case '\u010c': {
                    sb.append('C');
                    continue block21;
                }
                case '\u0160': {
                    sb.append('S');
                    continue block21;
                }
                case '\u017d': {
                    sb.append('Z');
                    continue block21;
                }
                case '\u010d': {
                    sb.append('c');
                    continue block21;
                }
                case '\u0161': {
                    sb.append('s');
                    continue block21;
                }
                case '\u017e': {
                    sb.append('z');
                    continue block21;
                }
                case '\u00df': {
                    sb.append("ss");
                    continue block21;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        sb.append(c);
                        continue block21;
                    }
                    sb.append('_');
                }
            }
        }
        return sb.toString();
    }

    public static String escapeJava(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(Math.min(2, s.length() * 3 / 2));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                sb.append("\\u");
                sb.append(StringHelper.hex4(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String hex4(char c) {
        char[] r = new char[]{'0', '0', '0', '0'};
        int i = 3;
        while (c > '\u0000') {
            r[i] = HEX_DIGITS[c & 0xF];
            c = (char)(c >>> 4);
            --i;
        }
        return new String(r);
    }

    public static int overlap(CharSequence a, CharSequence b) {
        int start;
        if (a == null || b == null || a.length() == 0 || b.length() == 0) {
            return 0;
        }
        for (int i = start = Math.max(0, a.length() - b.length()); i < a.length(); ++i) {
            int j;
            for (j = 0; j < b.length() && i + j < a.length() && a.charAt(i + j) == b.charAt(j); ++j) {
            }
            if (i + j != a.length()) continue;
            return j;
        }
        return 0;
    }

    private static List<String> split(String str) {
        ArrayList<String> result = new ArrayList<String>();
        int s = 0;
        for (int i = 0; i <= str.length(); ++i) {
            if (i == str.length()) {
                result.add(str.substring(s, i));
                break;
            }
            char c = str.charAt(i);
            if (!Character.isSpaceChar(c) && c != ':' && c != '\u2014' && c != '\u2013' && c != '-') continue;
            result.add(str.substring(s, i));
            result.add(str.substring(i, i + 1));
            s = i + 1;
        }
        return result;
    }

    private static boolean isStopWord(String w) {
        for (String titlecaseStopword : TITLECASE_STOPWORDS) {
            if (!w.equalsIgnoreCase(titlecaseStopword)) continue;
            return true;
        }
        return false;
    }

    private static boolean safeEquals(List<String> l, int i, String other) {
        return i >= 0 && i < l.size() && l.get(i).equals(other);
    }

    private static boolean isAllUppercase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    private static boolean shouldNotCapitalize(String s) {
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c < 'A' || c > 'Z') && (c != '.' || i >= s.length() - 1)) continue;
            return true;
        }
        return false;
    }

    public static String toTitleCase(String str) {
        if (str == null) {
            return null;
        }
        List<String> l = StringHelper.split(str);
        block0: for (int i = 0; i < l.size(); ++i) {
            String w = l.get(i);
            if (StringHelper.isStopWord(w) && i != 0 && i != l.size() - 1 && !StringHelper.safeEquals(l, i - 3, ":") && !StringHelper.safeEquals(l, i + 1, ":") && (!StringHelper.safeEquals(l, i + 1, "-") || StringHelper.safeEquals(l, i - 1, "-") && StringHelper.safeEquals(l, i + 1, "-"))) {
                if (StringHelper.isAllUppercase(w)) continue;
                l.set(i, l.get(i).toLowerCase());
                continue;
            }
            if (StringHelper.shouldNotCapitalize(w) || StringHelper.safeEquals(l, i + 1, ":") && !StringHelper.safeEquals(l, i + 2, "")) continue;
            for (int j = 0; j < w.length(); ++j) {
                char c = w.charAt(j);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') && (c < '\u00c0' || c > '\u00ff')) continue;
                l.set(i, w.substring(0, j) + Character.toTitleCase(c) + w.substring(j + 1));
                continue block0;
            }
        }
        return String.join((CharSequence)"", l);
    }

    public static String initializeName(String name, String initializeWith) {
        return StringHelper.initializeName(name, initializeWith, false);
    }

    public static String initializeName(String name, String initializeWith, boolean onlyNormalize) {
        name = name.trim().replaceAll("\\s+", " ").replaceAll("\\s*\\.", ".").replaceAll("\\.+", ".").replaceAll("\\s*[-\u2010\u2011\u2012\u2013\u2014\u2015]+\\s*", "-");
        ArrayList<NamePart> parts = new ArrayList<NamePart>();
        int lp = 0;
        for (int i = 1; i <= name.length(); ++i) {
            String sub;
            if (i == name.length() || name.charAt(i) == ' ') {
                if (i > lp) {
                    parts.add(new NamePart(sub, false, (sub = name.substring(lp, i)).length() == 1 && StringHelper.isAllUppercase(sub)));
                }
                lp = i + 1;
                continue;
            }
            if (name.charAt(i) == '-') {
                if (i > lp) {
                    parts.add(new NamePart(sub, true, (sub = name.substring(lp, i)).length() == 1 && StringHelper.isAllUppercase(sub)));
                }
                lp = i + 1;
                continue;
            }
            if (name.charAt(i) == '.' && i < name.length() - 1 && name.charAt(i + 1) == '-') {
                if (i > lp) {
                    parts.add(new NamePart(name.substring(lp, i), true, true));
                }
                lp = ++i + 1;
                continue;
            }
            if (name.charAt(i) != '.') continue;
            if (i > lp) {
                parts.add(new NamePart(name.substring(lp, i), false, true));
            }
            lp = i + 1;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            NamePart p = (NamePart)parts.get(i);
            if (!(!onlyNormalize || i <= 0 || p.alreadyInitialized && ((NamePart)parts.get((int)(i - 1))).alreadyInitialized || result.length() <= 0 || result.charAt(result.length() - 1) == ' ' || result.charAt(result.length() - 1) == '-')) {
                result.append(" ");
            }
            if (onlyNormalize || p.alreadyInitialized) {
                result.append(p.part);
            } else {
                result.append(p.part.charAt(0));
            }
            if (!onlyNormalize || p.alreadyInitialized) {
                result.append(initializeWith);
            }
            if (!p.hyphen) continue;
            result.append("-");
        }
        return result.toString().replaceAll("\\s+-", "-").trim();
    }

    private static class NamePart {
        final String part;
        final boolean hyphen;
        final boolean alreadyInitialized;

        NamePart(String part, boolean hyphen, boolean alreadyInitialized) {
            this.part = part;
            this.hyphen = hyphen;
            this.alreadyInitialized = alreadyInitialized;
        }
    }
}

