/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.rendering;

import de.undercouch.citeproc.csl.internal.CountingVariableListener;
import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SRenderingElementContainerElement;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.behavior.Affixes;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.rendering.SRenderingElement;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.List;
import org.w3c.dom.Node;

public class SGroup
extends SRenderingElementContainerElement
implements SRenderingElement {
    private final Affixes affixes;
    private final int formattingAttributes;
    private final String delimiter;

    public SGroup(Node node) {
        super(node);
        this.affixes = new Affixes(node);
        this.formattingAttributes = FormattingAttributes.of(node);
        this.delimiter = NodeHelper.getAttrValue(node, "delimiter");
    }

    @Override
    public void render(RenderContext ctx) {
        this.affixes.accept(this::renderInternal, ctx);
    }

    private void renderInternal(RenderContext ctx) {
        boolean allEmpty;
        RenderContext child = new RenderContext(ctx);
        CountingVariableListener vl = new CountingVariableListener();
        child.addVariableListener(vl);
        List<SRenderingElement> elements = this.getElements(ctx);
        for (SRenderingElement e : elements) {
            RenderContext tmp = new RenderContext(child);
            e.render(tmp);
            if (tmp.getResult().isEmpty()) continue;
            if (this.delimiter != null && !child.getResult().isEmpty()) {
                child.emit(this.delimiter, Token.Type.DELIMITER);
            }
            child.emit(tmp.getResult());
        }
        child.removeVariableListener(vl);
        boolean bl = allEmpty = vl.getCalled() > 0 && vl.getCalled() == vl.getEmpty();
        if (!allEmpty && !child.getResult().isEmpty()) {
            ctx.emit(child.getResult(), this.formattingAttributes);
            ctx.getVariableListeners().forEach(l -> l.onFetchStringVariable("__dummy_group_variable", "__dummy_value"));
        }
    }
}

