/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.format;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.SBibliography;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.format.BaseFormat;
import de.undercouch.citeproc.output.Bibliography;
import de.undercouch.citeproc.output.SecondFieldAlign;
import org.apache.commons.text.StringEscapeUtils;

public class HtmlFormat
extends BaseFormat {
    @Override
    public String getName() {
        return "html";
    }

    @Override
    protected String doFormatCitation(TokenBuffer buffer, RenderContext ctx) {
        return this.format(buffer);
    }

    @Override
    protected String doFormatBibliographyEntry(TokenBuffer buffer, RenderContext ctx, int index) {
        String result;
        SecondFieldAlign sfa = ctx.getStyle().getBibliography().getSecondFieldAlign();
        if (sfa != SecondFieldAlign.FALSE && !buffer.getTokens().isEmpty()) {
            int i = 0;
            while (buffer.getTokens().get(i).isFirstField()) {
                ++i;
            }
            TokenBuffer firstBuffer = buffer.copy(0, i);
            TokenBuffer restBuffer = buffer.copy(i, buffer.getTokens().size());
            result = "\n    <div class=\"csl-left-margin\">" + this.format(firstBuffer) + "</div><div class=\"csl-right-inline\">" + this.format(restBuffer) + "</div>\n  ";
        } else {
            result = this.format(buffer);
        }
        return "  <div class=\"csl-entry\">" + result + "</div>\n";
    }

    @Override
    protected String doFormatLink(String text, String uri) {
        return "<a href=\"" + uri + "\">" + text + "</a>";
    }

    @Override
    public Bibliography makeBibliography(String[] entries, SBibliography bibliographyElement) {
        SecondFieldAlign sfa = bibliographyElement.getSecondFieldAlign();
        return new Bibliography(entries, "<div class=\"csl-bib-body\">\n", "</div>", null, null, null, null, null, null, sfa);
    }

    @Override
    protected String escape(String str) {
        return StringEscapeUtils.escapeHtml4((String)str);
    }

    @Override
    protected String openFontStyle(int fontStyle) {
        if (fontStyle == 2) {
            return "<span style=\"font-style: italic\">";
        }
        return "<span style=\"font-style: oblique\">";
    }

    @Override
    protected String closeFontStyle(int fontStyle) {
        return "</span>";
    }

    @Override
    protected String openFontVariant(int fontVariant) {
        return "<span style=\"font-variant: small-caps\">";
    }

    @Override
    protected String closeFontVariant(int fontVariant) {
        return "</span>";
    }

    @Override
    protected String openFontWeight(int fontWeight) {
        if (fontWeight == 2) {
            return "<span style=\"font-weight: bold\">";
        }
        return "<span style=\"font-weight: 100\">";
    }

    @Override
    protected String closeFontWeight(int fontWeight) {
        return "</span>";
    }

    @Override
    protected String openTextDecoration(int textDecoration) {
        return "<span style=\"text-decoration: underline\">";
    }

    @Override
    protected String closeTextDecoration(int textDecoration) {
        return "</span>";
    }

    @Override
    protected String openVerticalAlign(int verticalAlign) {
        if (verticalAlign == 2) {
            return "<sup>";
        }
        return "<sub>";
    }

    @Override
    protected String closeVerticalAlign(int verticalAlign) {
        if (verticalAlign == 2) {
            return "</sup>";
        }
        return "</sub>";
    }
}

