/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.behavior;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.Token;
import de.undercouch.citeproc.csl.internal.behavior.Behavior;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

public class StripPeriods
implements Behavior {
    private final boolean stripPeriods;

    public StripPeriods() {
        this.stripPeriods = false;
    }

    public StripPeriods(Node node) {
        this.stripPeriods = Boolean.parseBoolean(NodeHelper.getAttrValue(node, "strip-periods"));
    }

    @Override
    public void accept(Consumer<RenderContext> renderFunction, RenderContext ctx) {
        if (this.stripPeriods) {
            RenderContext child = new RenderContext(ctx);
            renderFunction.accept(child);
            child.getResult().getTokens().stream().map(this::transform).forEach(ctx::emit);
        } else {
            renderFunction.accept(ctx);
        }
    }

    private Token transform(Token t) {
        String s = StringUtils.remove((String)t.getText(), (char)'.');
        return new Token.Builder(t).text(s).build();
    }
}

