/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.bibtex;

import de.undercouch.citeproc.bibtex.DateParser;
import de.undercouch.citeproc.bibtex.NameParser;
import de.undercouch.citeproc.bibtex.PageParser;
import de.undercouch.citeproc.bibtex.PageRange;
import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLItemDataBuilder;
import de.undercouch.citeproc.csl.CSLType;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXParser;
import org.jbibtex.BibTeXString;
import org.jbibtex.Key;
import org.jbibtex.LaTeXParser;
import org.jbibtex.LaTeXPrinter;
import org.jbibtex.ParseException;
import org.jbibtex.TokenMgrException;
import org.jbibtex.Value;

public class BibTeXConverter {
    private static final String FIELD_ABSTRACT = "abstract";
    private static final String FIELD_ACCESSED = "accessed";
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_ANNOTE = "annote";
    private static final String FIELD_AUTHOR = "author";
    private static final String FIELD_BOOKTITLE = "booktitle";
    private static final String FIELD_CHAPTER = "chapter";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_DOI = "doi";
    private static final String FIELD_EDITION = "edition";
    private static final String FIELD_EDITOR = "editor";
    private static final String FIELD_INSTITUTION = "institution";
    private static final String FIELD_ISBN = "isbn";
    private static final String FIELD_ISSN = "issn";
    private static final String FIELD_ISSUE = "issue";
    private static final String FIELD_JOURNAL = "journal";
    private static final String FIELD_JOURNALTITLE = "journaltitle";
    private static final String FIELD_KEYWORDS = "keywords";
    private static final String FIELD_LANGUAGE = "language";
    private static final String FIELD_LOCATION = "location";
    private static final String FIELD_MONTH = "month";
    private static final String FIELD_NOTE = "note";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_ORGANIZATION = "organization";
    private static final String FIELD_PAGES = "pages";
    private static final String FIELD_PUBLISHER = "publisher";
    private static final String FIELD_REVISION = "revision";
    private static final String FIELD_SCHOOL = "school";
    private static final String FIELD_SERIES = "series";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_URL = "url";
    private static final String FIELD_URLDATE = "urldate";
    private static final String FIELD_VOLUME = "volume";
    private static final String FIELD_YEAR = "year";
    private static final String TYPE_ARTICLE = "article";
    private static final String TYPE_BOOK = "book";
    private static final String TYPE_BOOKLET = "booklet";
    private static final String TYPE_CONFERENCE = "conference";
    private static final String TYPE_ELECTRONIC = "electronic";
    private static final String TYPE_INBOOK = "inbook";
    private static final String TYPE_INCOLLECTION = "incollection";
    private static final String TYPE_INPROCEEDINGS = "inproceedings";
    private static final String TYPE_MANUAL = "manual";
    private static final String TYPE_MASTERSTHESIS = "mastersthesis";
    private static final String TYPE_ONLINE = "online";
    private static final String TYPE_PATENT = "patent";
    private static final String TYPE_PERIODICAL = "periodical";
    private static final String TYPE_PHDTHESIS = "phdthesis";
    private static final String TYPE_PROCEEDINGS = "proceedings";
    private static final String TYPE_STANDARD = "standard";
    private static final String TYPE_TECHREPORT = "techreport";
    private static final String TYPE_UNPUBLISHED = "unpublished";
    private static final String TYPE_WWW = "www";
    private final LaTeXParser latexParser;
    private final LaTeXPrinter latexPrinter;

    public BibTeXConverter() {
        try {
            this.latexParser = new LaTeXParser();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        this.latexPrinter = new LaTeXPrinter();
    }

    public BibTeXDatabase loadDatabase(InputStream is) throws ParseException {
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        BibTeXParser parser = new BibTeXParser(){

            public void checkStringResolution(Key key, BibTeXString string) {
            }
        };
        try {
            return parser.parse((Reader)reader);
        }
        catch (TokenMgrException err) {
            throw new ParseException("Could not parse BibTeX library: " + err.getMessage());
        }
    }

    public Map<String, CSLItemData> toItemData(BibTeXDatabase db) {
        LinkedHashMap<String, CSLItemData> result = new LinkedHashMap<String, CSLItemData>();
        for (Map.Entry e : db.getEntries().entrySet()) {
            result.put(((Key)e.getKey()).getValue(), this.toItemData((BibTeXEntry)e.getValue()));
        }
        return result;
    }

    public CSLItemData toItemData(BibTeXEntry e) {
        HashMap<String, String> entries = new HashMap<String, String>();
        for (Map.Entry field : e.getFields().entrySet()) {
            String us = ((Value)field.getValue()).toUserString().replaceAll("\\r", "");
            try {
                List objs = this.latexParser.parse((Reader)new StringReader(us));
                us = this.latexPrinter.print(objs).replaceAll("\\n", " ").replaceAll("\\r", "").trim();
            }
            catch (ParseException | TokenMgrException objs) {
                // empty catch block
            }
            entries.put(((Key)field.getKey()).getValue().toLowerCase(), us);
        }
        CSLType type = this.toType(e.getType());
        CSLItemDataBuilder builder = new CSLItemDataBuilder().id(e.getKey().getValue()).type(type);
        if (entries.containsKey(FIELD_LOCATION)) {
            builder.eventPlace((String)entries.get(FIELD_LOCATION));
            builder.publisherPlace((String)entries.get(FIELD_LOCATION));
        } else {
            builder.eventPlace((String)entries.get(FIELD_ADDRESS));
            builder.publisherPlace((String)entries.get(FIELD_ADDRESS));
        }
        if (entries.containsKey(FIELD_AUTHOR)) {
            builder.author(NameParser.parse((String)entries.get(FIELD_AUTHOR)));
        }
        if (entries.containsKey(FIELD_EDITOR)) {
            builder.editor(NameParser.parse((String)entries.get(FIELD_EDITOR)));
            builder.collectionEditor(NameParser.parse((String)entries.get(FIELD_EDITOR)));
        }
        CSLDate date = entries.containsKey(FIELD_DATE) ? DateParser.toDate((String)entries.get(FIELD_DATE)) : DateParser.toDate((String)entries.get(FIELD_YEAR), (String)entries.get(FIELD_MONTH));
        builder.issued(date);
        builder.eventDate(date);
        if (entries.containsKey(FIELD_URLDATE)) {
            CSLDate urlDate = DateParser.toDate((String)entries.get(FIELD_URLDATE));
            builder.accessed(urlDate);
        }
        if (entries.containsKey(FIELD_JOURNAL)) {
            builder.containerTitle((String)entries.get(FIELD_JOURNAL));
        } else if (entries.containsKey(FIELD_JOURNALTITLE)) {
            builder.containerTitle((String)entries.get(FIELD_JOURNALTITLE));
        } else if (entries.containsKey(FIELD_BOOKTITLE)) {
            builder.containerTitle((String)entries.get(FIELD_BOOKTITLE));
        } else {
            builder.collectionTitle((String)entries.get(FIELD_SERIES));
        }
        if (entries.containsKey(FIELD_SERIES)) {
            if (entries.containsKey(FIELD_JOURNAL)) {
                builder.containerTitle((String)entries.get(FIELD_JOURNAL));
                builder.collectionTitle((String)entries.get(FIELD_SERIES));
            } else if (entries.containsKey(FIELD_JOURNALTITLE)) {
                builder.containerTitle((String)entries.get(FIELD_JOURNALTITLE));
                builder.collectionTitle((String)entries.get(FIELD_SERIES));
            } else if (entries.containsKey(FIELD_BOOKTITLE)) {
                builder.containerTitle((String)entries.get(FIELD_BOOKTITLE));
                builder.collectionTitle((String)entries.get(FIELD_SERIES));
            }
        }
        builder.number((String)entries.get(FIELD_NUMBER));
        builder.issue((String)entries.get(FIELD_ISSUE));
        if (type == CSLType.REPORT) {
            if (entries.containsKey(FIELD_PUBLISHER)) {
                builder.publisher((String)entries.get(FIELD_PUBLISHER));
            } else if (entries.containsKey(FIELD_INSTITUTION)) {
                builder.publisher((String)entries.get(FIELD_INSTITUTION));
            } else if (entries.containsKey(FIELD_SCHOOL)) {
                builder.publisher((String)entries.get(FIELD_SCHOOL));
            } else {
                builder.publisher((String)entries.get(FIELD_ORGANIZATION));
            }
        } else if (type == CSLType.THESIS) {
            if (entries.containsKey(FIELD_PUBLISHER)) {
                builder.publisher((String)entries.get(FIELD_PUBLISHER));
            } else if (entries.containsKey(FIELD_SCHOOL)) {
                builder.publisher((String)entries.get(FIELD_SCHOOL));
            } else if (entries.containsKey(FIELD_INSTITUTION)) {
                builder.publisher((String)entries.get(FIELD_INSTITUTION));
            } else {
                builder.publisher((String)entries.get(FIELD_ORGANIZATION));
            }
        } else if (entries.containsKey(FIELD_PUBLISHER)) {
            builder.publisher((String)entries.get(FIELD_PUBLISHER));
        } else if (entries.containsKey(FIELD_ORGANIZATION)) {
            builder.publisher((String)entries.get(FIELD_ORGANIZATION));
        } else if (entries.containsKey(FIELD_INSTITUTION)) {
            builder.publisher((String)entries.get(FIELD_INSTITUTION));
        } else {
            builder.publisher((String)entries.get(FIELD_SCHOOL));
        }
        if (entries.containsKey(FIELD_TITLE)) {
            builder.title((String)entries.get(FIELD_TITLE));
        } else {
            builder.title((String)entries.get(FIELD_CHAPTER));
        }
        String pages = (String)entries.get(FIELD_PAGES);
        if (pages != null) {
            PageRange pr = PageParser.parse(pages);
            builder.page(pr.getLiteral());
            builder.pageFirst(pr.getPageFirst());
            if (pr.getNumberOfPages() != null) {
                builder.numberOfPages(String.valueOf(pr.getNumberOfPages()));
            }
        }
        if (entries.containsKey(FIELD_ACCESSED)) {
            builder.accessed(DateParser.toDate((String)entries.get(FIELD_ACCESSED)));
        }
        switch (type) {
            case BOOK: 
            case MANUSCRIPT: 
            case MAP: 
            case MOTION_PICTURE: 
            case PERSONAL_COMMUNICATION: 
            case POST: 
            case POST_WEBLOG: 
            case REPORT: 
            case SPEECH: 
            case THESIS: 
            case WEBPAGE: {
                if (!entries.containsKey(FIELD_TYPE)) break;
                builder.genre((String)entries.get(FIELD_TYPE));
                break;
            }
        }
        if (entries.containsKey(FIELD_LANGUAGE)) {
            builder.language((String)entries.get(FIELD_LANGUAGE));
        }
        builder.volume((String)entries.get(FIELD_VOLUME));
        builder.keyword((String)entries.get(FIELD_KEYWORDS));
        builder.URL((String)entries.get(FIELD_URL));
        builder.status((String)entries.get(FIELD_STATUS));
        builder.ISSN((String)entries.get(FIELD_ISSN));
        builder.ISBN((String)entries.get(FIELD_ISBN));
        builder.version((String)entries.get(FIELD_REVISION));
        builder.annote((String)entries.get(FIELD_ANNOTE));
        builder.edition((String)entries.get(FIELD_EDITION));
        builder.abstrct((String)entries.get(FIELD_ABSTRACT));
        builder.DOI((String)entries.get(FIELD_DOI));
        builder.note((String)entries.get(FIELD_NOTE));
        return builder.build();
    }

    public CSLType toType(Key type) {
        String s = type.getValue();
        if (s.equalsIgnoreCase(TYPE_ARTICLE)) {
            return CSLType.ARTICLE_JOURNAL;
        }
        if (s.equalsIgnoreCase(TYPE_PROCEEDINGS)) {
            return CSLType.BOOK;
        }
        if (s.equalsIgnoreCase(TYPE_MANUAL)) {
            return CSLType.BOOK;
        }
        if (s.equalsIgnoreCase(TYPE_BOOK)) {
            return CSLType.BOOK;
        }
        if (s.equalsIgnoreCase(TYPE_PERIODICAL)) {
            return CSLType.BOOK;
        }
        if (s.equalsIgnoreCase(TYPE_BOOKLET)) {
            return CSLType.PAMPHLET;
        }
        if (s.equalsIgnoreCase(TYPE_INBOOK)) {
            return CSLType.CHAPTER;
        }
        if (s.equalsIgnoreCase(TYPE_INCOLLECTION)) {
            return CSLType.CHAPTER;
        }
        if (s.equalsIgnoreCase(TYPE_INPROCEEDINGS)) {
            return CSLType.PAPER_CONFERENCE;
        }
        if (s.equalsIgnoreCase(TYPE_CONFERENCE)) {
            return CSLType.PAPER_CONFERENCE;
        }
        if (s.equalsIgnoreCase(TYPE_MASTERSTHESIS)) {
            return CSLType.THESIS;
        }
        if (s.equalsIgnoreCase(TYPE_PHDTHESIS)) {
            return CSLType.THESIS;
        }
        if (s.equalsIgnoreCase(TYPE_TECHREPORT)) {
            return CSLType.REPORT;
        }
        if (s.equalsIgnoreCase(TYPE_PATENT)) {
            return CSLType.PATENT;
        }
        if (s.equalsIgnoreCase(TYPE_ELECTRONIC)) {
            return CSLType.WEBPAGE;
        }
        if (s.equalsIgnoreCase(TYPE_ONLINE)) {
            return CSLType.WEBPAGE;
        }
        if (s.equalsIgnoreCase(TYPE_WWW)) {
            return CSLType.WEBPAGE;
        }
        if (s.equalsIgnoreCase(TYPE_STANDARD)) {
            return CSLType.LEGISLATION;
        }
        if (s.equalsIgnoreCase(TYPE_UNPUBLISHED)) {
            return CSLType.MANUSCRIPT;
        }
        return CSLType.ARTICLE;
    }
}

