package de.undercouch.citeproc.ris;

import de.undercouch.citeproc.CSL;
import de.undercouch.citeproc.ListItemDataProvider;

/**
 * Loads citation items from a RIS library
 * 
 * @author Michel Kraemer
 */
public class RISItemDataProvider extends ListItemDataProvider {
    /**
     * Adds the given library
     * 
     * @param lib
     *            the library to add
     */
    public void addLibrary(RISLibrary lib) {
        items.putAll(new RISConverter().toItemData(lib));
    }

    /**
     * Introduces all citation items from the RIS libraries added via
     * {@link #addLibrary(RISLibrary)} to the given CSL processor
     * 
     * @see CSL#registerCitationItems(String[])
     * @param citeproc
     *            the CSL processor
     */
    public void registerCitationItems(CSL citeproc) {
        citeproc.registerCitationItems(getIds());
    }
}
