package de.undercouch.citeproc.output;

/**
 * Specifies whether subsequent lines of bibliographies should be aligned along
 * the second field
 * 
 * @author Michel Kraemer
 */
public enum SecondFieldAlign {
    FLUSH("flush"), MARGIN("margin"), FALSE("false");

    private String name;

    SecondFieldAlign(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }

    /**
     * Converts the given string to a SecondFieldAlign
     * 
     * @param str
     *            the string
     * @return the converted SecondFieldAlign
     */
    public static SecondFieldAlign fromString(String str) {
        if (str.equals("flush")) {
            return FLUSH;
        }
        if (str.equals("margin")) {
            return MARGIN;
        }
        if (str.equals("false")) {
            return FALSE;
        }
        throw new IllegalArgumentException("Unknown SecondFieldAlign: " + str);
    }
}
