package de.undercouch.citeproc.endnote;

import de.undercouch.citeproc.CSL;
import de.undercouch.citeproc.ListItemDataProvider;

/**
 * Loads citation items from a EndNote library
 * 
 * @author Michel Kraemer
 */
public class EndNoteItemDataProvider extends ListItemDataProvider {
    /**
     * Adds the given library
     * 
     * @param lib
     *            the library to add
     */
    public void addLibrary(EndNoteLibrary lib) {
        items.putAll(new EndNoteConverter().toItemData(lib));
    }

    /**
     * Introduces all citation items from the EndNote libraries added via
     * {@link #addLibrary(EndNoteLibrary)} to the given CSL processor
     * 
     * @see CSL#registerCitationItems(String[])
     * @param citeproc
     *            the CSL processor
     */
    public void registerCitationItems(CSL citeproc) {
        citeproc.registerCitationItems(getIds());
    }
}
