package de.undercouch.citeproc.csl;

import java.util.Map;

/**
 * Builder for {@link CSLDate}
 * 
 * @author Michel Kraemer
 */
public class CSLDateBuilder {

    private int[][] dateParts;
    private String season;
    private Boolean circa;
    private String literal;
    private String raw;

    public CSLDateBuilder() {

        this.dateParts = null;
        this.season = null;
        this.circa = null;
        this.literal = null;
        this.raw = null;

    }

    public CSLDateBuilder dateParts(int[]... dateParts) {
        this.dateParts = dateParts;
        return this;
    }

    public CSLDateBuilder season(String season) {
        this.season = season;
        return this;
    }

    public CSLDateBuilder circa(Boolean circa) {
        this.circa = circa;
        return this;
    }

    public CSLDateBuilder literal(String literal) {
        this.literal = literal;
        return this;
    }

    public CSLDateBuilder raw(String raw) {
        this.raw = raw;
        return this;
    }

    /**
     * Creates a builder that copies properties from the given original object
     * 
     * @param original
     *            the original object
     */
    public CSLDateBuilder(CSLDate original) {

        this.dateParts = original.getDateParts();
        this.season = original.getSeason();
        this.circa = original.getCirca();
        this.literal = original.getLiteral();
        this.raw = original.getRaw();
    }

    public CSLDate build() {
        return new CSLDate(dateParts, season, circa, literal, raw);
    }

    public CSLDateBuilder dateParts(int year) {
        dateParts(new int[]{year});
        return this;
    }
    public CSLDateBuilder dateParts(int year, int month) {
        dateParts(new int[]{year, month});
        return this;
    }
    public CSLDateBuilder dateParts(int year, int month, int day) {
        dateParts(new int[]{year, month, day});
        return this;
    }
    public CSLDateBuilder season(int season) {
        season(String.valueOf(season));
        return this;
    }
}
