package de.undercouch.citeproc.csl;

import java.util.Map;

/**
 * Builder for {@link CSLCitation}
 * 
 * @author Michel Kraemer
 */
public class CSLCitationBuilder {
    private CSLCitationItem[] citationItems;

    private String citationID;
    private CSLProperties properties;

    public CSLCitationBuilder(CSLCitationItem... citationItems) {
        this.citationItems = citationItems;

        this.citationID = Long.toString((long) Math.floor(Math.random() * 100000000000000L), 32);
        this.properties = new CSLProperties();

    }

    public CSLCitationBuilder citationID(String citationID) {
        this.citationID = citationID;
        return this;
    }

    public CSLCitationBuilder properties(CSLProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Creates a builder that copies properties from the given original object
     * 
     * @param original
     *            the original object
     */
    public CSLCitationBuilder(CSLCitation original) {
        this.citationItems = original.getCitationItems();
        this.citationID = original.getCitationID();
        this.properties = original.getProperties();
    }

    public CSLCitation build() {
        return new CSLCitation(citationItems, citationID, properties);
    }

    public CSLCitationBuilder citationID(long citationID) {
        citationID(String.valueOf(citationID));
        return this;
    }
}
