package de.undercouch.citeproc;

/**
 * Selection modes for
 * {@link CSL#makeBibliography(SelectionMode, de.undercouch.citeproc.csl.CSLItemData[])}.
 * 
 * @author Michel Kraemer
 */
public enum SelectionMode {
    SELECT("select"), INCLUDE("include"), EXCLUDE("exclude");

    private String name;

    SelectionMode(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }

    /**
     * Converts the given string to a SelectionMode
     * 
     * @param str
     *            the string
     * @return the converted SelectionMode
     */
    public static SelectionMode fromString(String str) {
        if (str.equals("select")) {
            return SELECT;
        }
        if (str.equals("include")) {
            return INCLUDE;
        }
        if (str.equals("exclude")) {
            return EXCLUDE;
        }
        throw new IllegalArgumentException("Unknown SelectionMode: " + str);
    }
}
