/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc;

import de.undercouch.citeproc.Context;
import de.undercouch.citeproc.VariableWrapperParamsBuilder;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class VariableWrapperParams
implements JsonObject {
    private final CSLItemData itemData;
    private final String[] variableNames;
    private final Context context;
    private final String xclass;
    private final String position;
    private final Integer noteNumber;
    private final Integer firstReferenceNoteNumber;
    private final Integer citationNumber;
    private final Integer index;
    private final String mode;

    public VariableWrapperParams() {
        this.itemData = null;
        this.variableNames = null;
        this.context = null;
        this.xclass = null;
        this.position = null;
        this.noteNumber = null;
        this.firstReferenceNoteNumber = null;
        this.citationNumber = null;
        this.index = null;
        this.mode = null;
    }

    public VariableWrapperParams(CSLItemData itemData, String[] variableNames, Context context, String xclass, String position, Integer noteNumber, Integer firstReferenceNoteNumber, Integer citationNumber, Integer index, String mode) {
        this.itemData = itemData;
        this.variableNames = variableNames;
        this.context = context;
        this.xclass = xclass;
        this.position = position;
        this.noteNumber = noteNumber;
        this.firstReferenceNoteNumber = firstReferenceNoteNumber;
        this.citationNumber = citationNumber;
        this.index = index;
        this.mode = mode;
    }

    public CSLItemData getItemData() {
        return this.itemData;
    }

    public String[] getVariableNames() {
        return this.variableNames;
    }

    public Context getContext() {
        return this.context;
    }

    public String getXclass() {
        return this.xclass;
    }

    public String getPosition() {
        return this.position;
    }

    public Integer getNoteNumber() {
        return this.noteNumber;
    }

    public Integer getFirstReferenceNoteNumber() {
        return this.firstReferenceNoteNumber;
    }

    public Integer getCitationNumber() {
        return this.citationNumber;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    public Object toJson(JsonBuilder builder) {
        if (this.itemData != null) {
            builder.add("itemData", this.itemData);
        }
        if (this.variableNames != null) {
            builder.add("variableNames", this.variableNames);
        }
        if (this.context != null) {
            builder.add("context", (Object)this.context);
        }
        if (this.xclass != null) {
            builder.add("xclass", this.xclass);
        }
        if (this.position != null) {
            builder.add("position", this.position);
        }
        if (this.noteNumber != null) {
            builder.add("note-number", this.noteNumber);
        }
        if (this.firstReferenceNoteNumber != null) {
            builder.add("first-reference-note-number", this.firstReferenceNoteNumber);
        }
        if (this.citationNumber != null) {
            builder.add("citation-number", this.citationNumber);
        }
        if (this.index != null) {
            builder.add("index", this.index);
        }
        if (this.mode != null) {
            builder.add("mode", this.mode);
        }
        return builder.build();
    }

    public static VariableWrapperParams fromJson(Map<String, Object> obj) {
        VariableWrapperParamsBuilder builder = new VariableWrapperParamsBuilder();
        Collection v = obj.get("itemData");
        if (v != null) {
            if (!(v instanceof Map)) {
                throw new IllegalArgumentException("`itemData' must be an object");
            }
            CSLItemData itemData = CSLItemData.fromJson((Map)((Object)v));
            builder.itemData(itemData);
        }
        if ((v = obj.get("variableNames")) != null) {
            if (v instanceof Map) {
                v = ((Map)((Object)v)).values();
            } else if (!(v instanceof Collection)) {
                throw new IllegalArgumentException("`variableNames' must be an array");
            }
            Collection cv = v;
            String[] variableNames = new String[cv.size()];
            int i = 0;
            for (Object vo : cv) {
                variableNames[i] = vo.toString();
                ++i;
            }
            builder.variableNames(variableNames);
        }
        if (!VariableWrapperParams.isFalsy(v = obj.get("context"))) {
            Context context = Context.fromString(v.toString());
            builder.context(context);
        }
        if ((v = obj.get("xclass")) != null) {
            String xclass = v.toString();
            builder.xclass(xclass);
        }
        if ((v = obj.get("position")) != null) {
            String position = v.toString();
            builder.position(position);
        }
        if ((v = obj.get("note-number")) != null) {
            Integer noteNumber = VariableWrapperParams.toInt(v);
            builder.noteNumber(noteNumber);
        }
        if ((v = obj.get("first-reference-note-number")) != null) {
            Integer firstReferenceNoteNumber = VariableWrapperParams.toInt(v);
            builder.firstReferenceNoteNumber(firstReferenceNoteNumber);
        }
        if ((v = obj.get("citation-number")) != null) {
            Integer citationNumber = VariableWrapperParams.toInt(v);
            builder.citationNumber(citationNumber);
        }
        if ((v = obj.get("index")) != null) {
            Integer index = VariableWrapperParams.toInt(v);
            builder.index(index);
        }
        if ((v = obj.get("mode")) != null) {
            String mode = v.toString();
            builder.mode(mode);
        }
        return builder.build();
    }

    private static boolean isFalsy(Object o) {
        if (o == null) {
            return true;
        }
        if (Boolean.FALSE.equals(o)) {
            return true;
        }
        if ("".equals(o)) {
            return true;
        }
        if (Integer.valueOf(0).equals(o)) {
            return true;
        }
        if (Long.valueOf(0L).equals(o)) {
            return true;
        }
        if (o instanceof Float && (Float.valueOf(0.0f).equals(o) || ((Float)o).isNaN())) {
            return true;
        }
        if (o instanceof Double && (Double.valueOf(0.0).equals(o) || ((Double)o).isNaN())) {
            return true;
        }
        if (Byte.valueOf((byte)0).equals(o)) {
            return true;
        }
        return Short.valueOf((short)0).equals(o);
    }

    private static int toInt(Object o) {
        if (o instanceof CharSequence) {
            return Integer.parseInt(o.toString());
        }
        return ((Number)o).intValue();
    }

    private static boolean toBool(Object o) {
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        return (Boolean)o;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.itemData == null ? 0 : this.itemData.hashCode());
        result = 31 * result + Arrays.hashCode(this.variableNames);
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.xclass == null ? 0 : this.xclass.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.noteNumber == null ? 0 : this.noteNumber.hashCode());
        result = 31 * result + (this.firstReferenceNoteNumber == null ? 0 : this.firstReferenceNoteNumber.hashCode());
        result = 31 * result + (this.citationNumber == null ? 0 : this.citationNumber.hashCode());
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableWrapperParams)) {
            return false;
        }
        VariableWrapperParams other = (VariableWrapperParams)obj;
        if (this.itemData == null ? other.itemData != null : !this.itemData.equals(other.itemData)) {
            return false;
        }
        if (!Arrays.equals(this.variableNames, other.variableNames)) {
            return false;
        }
        if (this.context == null ? other.context != null : !this.context.equals((Object)other.context)) {
            return false;
        }
        if (this.xclass == null ? other.xclass != null : !this.xclass.equals(other.xclass)) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        if (this.noteNumber == null ? other.noteNumber != null : !this.noteNumber.equals(other.noteNumber)) {
            return false;
        }
        if (this.firstReferenceNoteNumber == null ? other.firstReferenceNoteNumber != null : !this.firstReferenceNoteNumber.equals(other.firstReferenceNoteNumber)) {
            return false;
        }
        if (this.citationNumber == null ? other.citationNumber != null : !this.citationNumber.equals(other.citationNumber)) {
            return false;
        }
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        return !(this.mode == null ? other.mode != null : !this.mode.equals(other.mode));
    }
}

