/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.zotero;

import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.json.JsonLexer;
import de.undercouch.citeproc.helper.json.JsonParser;
import de.undercouch.citeproc.helper.oauth.OAuth;
import de.undercouch.citeproc.helper.oauth.Response;
import de.undercouch.citeproc.helper.oauth.UnauthorizedException;
import de.undercouch.citeproc.remote.AbstractRemoteConnector;
import de.undercouch.citeproc.zotero.ZoteroOAuth;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ZoteroConnector
extends AbstractRemoteConnector {
    private static final String OAUTH_ACCESS_TOKEN_URL = "https://www.zotero.org/oauth/access";
    private static final String OAUTH_REQUEST_TOKEN_URL = "https://www.zotero.org/oauth/request";
    private static final String OAUTH_AUTHORIZATION_URL = "https://www.zotero.org/oauth/authorize?name=citeproc-java&library_access=1&oauth_token=";
    private static final String ENDPOINT_USERS = "https://api.zotero.org/users/";
    private static final String CSLJSON = "csljson";
    private static final Map<String, String> REQUEST_HEADERS = new HashMap<String, String>();

    public ZoteroConnector(String consumerKey, String consumerSecret) {
        super(consumerKey, consumerSecret, null);
    }

    @Override
    protected String getOAuthRequestTokenURL() {
        return OAUTH_REQUEST_TOKEN_URL;
    }

    @Override
    protected String getOAuthAuthorizationURL() {
        return OAUTH_AUTHORIZATION_URL;
    }

    @Override
    protected String getOAuthAccessTokenURL() {
        return OAUTH_ACCESS_TOKEN_URL;
    }

    @Override
    protected OAuth.Method getOAuthAccessTokenMethod() {
        return OAuth.Method.GET;
    }

    @Override
    protected OAuth createOAuth(String consumerKey, String consumerSecret, String redirectUri) {
        return new ZoteroOAuth(consumerKey, consumerSecret);
    }

    @Override
    public List<String> getItemIDs() throws IOException {
        if (this.accessToken == null) {
            throw new UnauthorizedException("Access token has not yet been requested");
        }
        String userId = this.accessToken.getToken();
        String key = this.accessToken.getSecret();
        Map<String, Object> res = this.performRequestObject(ENDPOINT_USERS + userId + "/items?key=" + key + "&newer=0&format=versions&itemType=-attachment", REQUEST_HEADERS);
        return new ArrayList<String>(res.keySet());
    }

    @Override
    public CSLItemData getItem(String itemId) throws IOException {
        Map<String, CSLItemData> r = this.getItems(Arrays.asList(itemId));
        return r.get(itemId);
    }

    @Override
    protected Map<String, Object> parseResponseObject(Response response) throws IOException {
        String contentType = response.getHeader("Content-Type");
        InputStream is = response.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        if (contentType != null && contentType.equals("application/atom+xml")) {
            Document doc;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource source = new InputSource(r);
                doc = builder.parse(source);
            }
            catch (SAXException e) {
                throw new IOException("Could not parse server response", e);
            }
            catch (ParserConfigurationException e) {
                throw new IOException("Could not create XML parser", e);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            Element feed = doc.getDocumentElement();
            NodeList entries = feed.getElementsByTagName("entry");
            for (int i = 0; i < entries.getLength(); ++i) {
                Element entryElem;
                NodeList keys;
                String key = null;
                String csljson = null;
                Node entry = entries.item(i);
                if (entry instanceof Element && (keys = (entryElem = (Element)entry).getElementsByTagNameNS("http://zotero.org/ns/api", "key")).getLength() > 0) {
                    Node content;
                    Node type;
                    key = keys.item(0).getTextContent().trim();
                    NodeList contents = entryElem.getElementsByTagName("content");
                    if (contents.getLength() > 0 && (type = (content = contents.item(0)).getAttributes().getNamedItemNS("http://zotero.org/ns/api", "type")) != null && type.getTextContent().equals(CSLJSON)) {
                        csljson = content.getTextContent().trim();
                    }
                }
                if (csljson == null || csljson.isEmpty()) {
                    throw new IOException("Could not extract CSL json content from entry");
                }
                Map<String, Object> item = new JsonParser(new JsonLexer(new StringReader(csljson))).parseObject();
                result.put(key, item);
            }
            return result;
        }
        return super.parseResponseObject(response);
    }

    @Override
    public Map<String, CSLItemData> getItems(List<String> itemIds) throws IOException {
        int n;
        if (this.accessToken == null) {
            throw new UnauthorizedException("Access token has not yet been requested");
        }
        String userId = this.accessToken.getToken();
        String key = this.accessToken.getSecret();
        LinkedHashMap<String, CSLItemData> result = new LinkedHashMap<String, CSLItemData>(itemIds.size());
        for (int s = 0; s < itemIds.size(); s += n) {
            n = Math.min(this.getMaxBulkItems(), itemIds.size() - s);
            List<String> itemsToRequest = itemIds.subList(s, s + n);
            String istr = StringUtils.join(itemsToRequest, (char)',');
            Map<String, Object> res = this.performRequestObject(ENDPOINT_USERS + userId + "/items?key=" + key + "&content=" + CSLJSON + "&itemKey=" + istr, REQUEST_HEADERS);
            for (Map.Entry<String, Object> e : res.entrySet()) {
                String id = e.getKey();
                Map m = (Map)e.getValue();
                CSLItemData item = CSLItemData.fromJson(m);
                result.put(id, item);
            }
        }
        return result;
    }

    @Override
    public int getMaxBulkItems() {
        return 50;
    }

    static {
        REQUEST_HEADERS.put("Zotero-API-Version", "2");
    }
}

