/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.mendeley;

import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.oauth.OAuth;
import de.undercouch.citeproc.helper.oauth.OAuth2;
import de.undercouch.citeproc.helper.oauth.Response;
import de.undercouch.citeproc.mendeley.MendeleyConverter;
import de.undercouch.citeproc.remote.AbstractRemoteConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MendeleyConnector
extends AbstractRemoteConnector {
    private static final String OAUTH_ACCESS_TOKEN_URL = "https://api.mendeley.com/oauth/token";
    private static final String OAUTH_AUTHORIZATION_URL_TEMPLATE = "https://api.mendeley.com/oauth/authorize?redirect_uri=%s&response_type=code&scope=all&client_id=%s";
    private static final String MENDELEY_DOCUMENTS_ENDPOINT = "https://api.mendeley.com/documents/";
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    private static final String LINK = "Link";
    private static final String VIEWALL = "view=all";
    private final String oauthAuthorizationUrl;
    private Map<String, CSLItemData> cachedDocuments;

    public MendeleyConnector(String clientId, String clientSecret, String redirectUri) {
        super(clientId, clientSecret, redirectUri);
        try {
            this.oauthAuthorizationUrl = String.format(OAUTH_AUTHORIZATION_URL_TEMPLATE, URLEncoder.encode(redirectUri, "UTF-8"), clientId);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getOAuthRequestTokenURL() {
        return null;
    }

    @Override
    protected String getOAuthAuthorizationURL() {
        return this.oauthAuthorizationUrl;
    }

    @Override
    protected String getOAuthAccessTokenURL() {
        return OAUTH_ACCESS_TOKEN_URL;
    }

    @Override
    protected OAuth.Method getOAuthAccessTokenMethod() {
        return OAuth.Method.POST;
    }

    @Override
    protected OAuth createOAuth(String consumerKey, String consumerSecret, String redirectUri) {
        return new OAuth2(consumerKey, consumerSecret, redirectUri);
    }

    private void addToCache(String id, CSLItemData doc) {
        if (this.cachedDocuments == null) {
            this.cachedDocuments = new HashMap<String, CSLItemData>();
        }
        this.cachedDocuments.put(id, doc);
    }

    private CSLItemData getFromCache(String id) {
        if (this.cachedDocuments == null) {
            return null;
        }
        return this.cachedDocuments.get(id);
    }

    private void clearCache() {
        if (this.cachedDocuments != null) {
            this.cachedDocuments = null;
        }
    }

    @Override
    public List<String> getItemIDs() throws IOException {
        String nextLink = "https://api.mendeley.com/documents/?view=all";
        ArrayList<String> result = new ArrayList<String>();
        this.clearCache();
        while (nextLink != null) {
            Response response = this.performRequest(nextLink, DEFAULT_HEADERS);
            nextLink = null;
            List<String> linkHeaders = response.getHeaders(LINK);
            for (String linkHeader : linkHeaders) {
                String[] linksHeaderParts = linkHeader.split("\\s*,\\s*");
                for (String linksHeaderPart : linksHeaderParts) {
                    String[] parts = linksHeaderPart.split("\\s*;\\s*");
                    if (parts.length <= 1 || !parts[1].equals("rel=\"next\"")) continue;
                    nextLink = parts[0];
                    break;
                }
                if (nextLink == null) continue;
                if (nextLink.charAt(0) != '<' || nextLink.charAt(nextLink.length() - 1) != '>') break;
                nextLink = nextLink.substring(1, nextLink.length() - 1);
                break;
            }
            InputStream is = response.getInputStream();
            Throwable throwable = null;
            try {
                List<Object> docsArr = this.parseResponseArray(response);
                for (Object e : docsArr) {
                    if (!(e instanceof Map)) continue;
                    Map docMap = (Map)e;
                    String id = docMap.get("id").toString();
                    CSLItemData doc = MendeleyConverter.convert(id, docMap);
                    result.add(id);
                    this.addToCache(id, doc);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return result;
    }

    @Override
    public CSLItemData getItem(String itemId) throws IOException {
        CSLItemData item = this.getFromCache(itemId);
        if (item == null) {
            Map<String, Object> response = this.performRequestObject(MENDELEY_DOCUMENTS_ENDPOINT + itemId + "?" + VIEWALL, null);
            item = MendeleyConverter.convert(itemId, response);
            this.addToCache(itemId, item);
        }
        return item;
    }

    @Override
    public Map<String, CSLItemData> getItems(List<String> itemIds) throws IOException {
        LinkedHashMap<String, CSLItemData> result = new LinkedHashMap<String, CSLItemData>(itemIds.size());
        for (String id : itemIds) {
            result.put(id, this.getItem(id));
        }
        return result;
    }

    @Override
    public int getMaxBulkItems() {
        return 1;
    }

    static {
        DEFAULT_HEADERS.put("Accept", "application/vnd.mendeley-document.1+json");
    }
}

