// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.output;

/**
 * Specifies whether subsequent lines of bibliographies should be aligned along
 * the second field
 * 
 * @author Michel Kraemer
 */
public enum SecondFieldAlign {
	FLUSH("flush"), MARGIN("margin"), FALSE("false");

	private String name;

	private SecondFieldAlign(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return name;
	}

	/**
	 * Converts the given string to a SecondFieldAlign
	 * 
	 * @param str
	 *            the string
	 * @return the converted SecondFieldAlign
	 */
	public static SecondFieldAlign fromString(String str) {
		if (str.equals("flush")) {
			return FLUSH;
		}
		if (str.equals("margin")) {
			return MARGIN;
		}
		if (str.equals("false")) {
			return FALSE;
		}
		throw new IllegalArgumentException("Unknown SecondFieldAlign: " + str);
	}
}
