// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

import java.util.Map;

/**
 * Builder for {@link CSLProperties}
 * 
 * @author Michel Kraemer
 */
public class CSLPropertiesBuilder {

	private Integer noteIndex;
	private Boolean unsorted;

	public CSLPropertiesBuilder() {

		this.noteIndex = 0;
		this.unsorted = null;

	}

	public CSLPropertiesBuilder noteIndex(Integer noteIndex) {
		this.noteIndex = noteIndex;
		return this;
	}

	public CSLPropertiesBuilder unsorted(Boolean unsorted) {
		this.unsorted = unsorted;
		return this;
	}

	/**
	 * Creates a builder that copies properties from the given original object
	 * 
	 * @param original
	 *            the original object
	 */
	public CSLPropertiesBuilder(CSLProperties original) {

		this.noteIndex = original.getNoteIndex();
		this.unsorted = original.getUnsorted();
	}

	public CSLProperties build() {
		return new CSLProperties(noteIndex, unsorted);
	}

}
