// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

import java.util.Map;

/**
 * Builder for {@link CSLAbbreviationList}
 * 
 * @author Michel Kraemer
 */
public class CSLAbbreviationListBuilder {

	private Map<String, String> title;
	private Map<String, String> collectionTitle;
	private Map<String, String> containerTitle;
	private Map<String, String> number;
	private Map<String, String> place;
	private Map<String, String> nickname;
	private Map<String, String> classic;
	private Map<String, String> institution;
	private Map<String, String> hereinafter;

	public CSLAbbreviationListBuilder() {

		this.title = null;
		this.collectionTitle = null;
		this.containerTitle = null;
		this.number = null;
		this.place = null;
		this.nickname = null;
		this.classic = null;
		this.institution = null;
		this.hereinafter = null;

	}

	public CSLAbbreviationListBuilder title(Map<String, String> title) {
		this.title = title;
		return this;
	}

	public CSLAbbreviationListBuilder collectionTitle(
			Map<String, String> collectionTitle) {
		this.collectionTitle = collectionTitle;
		return this;
	}

	public CSLAbbreviationListBuilder containerTitle(
			Map<String, String> containerTitle) {
		this.containerTitle = containerTitle;
		return this;
	}

	public CSLAbbreviationListBuilder number(Map<String, String> number) {
		this.number = number;
		return this;
	}

	public CSLAbbreviationListBuilder place(Map<String, String> place) {
		this.place = place;
		return this;
	}

	public CSLAbbreviationListBuilder nickname(Map<String, String> nickname) {
		this.nickname = nickname;
		return this;
	}

	public CSLAbbreviationListBuilder classic(Map<String, String> classic) {
		this.classic = classic;
		return this;
	}

	public CSLAbbreviationListBuilder institution(
			Map<String, String> institution) {
		this.institution = institution;
		return this;
	}

	public CSLAbbreviationListBuilder hereinafter(
			Map<String, String> hereinafter) {
		this.hereinafter = hereinafter;
		return this;
	}

	/**
	 * Creates a builder that copies properties from the given original object
	 * 
	 * @param original
	 *            the original object
	 */
	public CSLAbbreviationListBuilder(CSLAbbreviationList original) {

		this.title = original.getTitle();
		this.collectionTitle = original.getCollectionTitle();
		this.containerTitle = original.getContainerTitle();
		this.number = original.getNumber();
		this.place = original.getPlace();
		this.nickname = original.getNickname();
		this.classic = original.getClassic();
		this.institution = original.getInstitution();
		this.hereinafter = original.getHereinafter();
	}

	public CSLAbbreviationList build() {
		return new CSLAbbreviationList(title, collectionTitle, containerTitle,
				number, place, nickname, classic, institution, hereinafter);
	}

}
