// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc;

import java.util.Map;

import de.undercouch.citeproc.csl.CSLItemData;

/**
 * Builder for {@link VariableWrapperParams}
 * 
 * @author Michel Kraemer
 */
public class VariableWrapperParamsBuilder {

	private CSLItemData itemData;
	private String[] variableNames;
	private Context context;
	private String xclass;
	private String position;
	private Integer noteNumber;
	private Integer firstReferenceNoteNumber;
	private Integer citationNumber;
	private Integer index;
	private String mode;

	public VariableWrapperParamsBuilder() {

		this.itemData = null;
		this.variableNames = null;
		this.context = null;
		this.xclass = null;
		this.position = null;
		this.noteNumber = null;
		this.firstReferenceNoteNumber = null;
		this.citationNumber = null;
		this.index = null;
		this.mode = null;

	}

	public VariableWrapperParamsBuilder itemData(CSLItemData itemData) {
		this.itemData = itemData;
		return this;
	}

	public VariableWrapperParamsBuilder variableNames(String... variableNames) {
		this.variableNames = variableNames;
		return this;
	}

	public VariableWrapperParamsBuilder context(Context context) {
		this.context = context;
		return this;
	}

	public VariableWrapperParamsBuilder xclass(String xclass) {
		this.xclass = xclass;
		return this;
	}

	public VariableWrapperParamsBuilder position(String position) {
		this.position = position;
		return this;
	}

	public VariableWrapperParamsBuilder noteNumber(Integer noteNumber) {
		this.noteNumber = noteNumber;
		return this;
	}

	public VariableWrapperParamsBuilder firstReferenceNoteNumber(
			Integer firstReferenceNoteNumber) {
		this.firstReferenceNoteNumber = firstReferenceNoteNumber;
		return this;
	}

	public VariableWrapperParamsBuilder citationNumber(Integer citationNumber) {
		this.citationNumber = citationNumber;
		return this;
	}

	public VariableWrapperParamsBuilder index(Integer index) {
		this.index = index;
		return this;
	}

	public VariableWrapperParamsBuilder mode(String mode) {
		this.mode = mode;
		return this;
	}

	/**
	 * Creates a builder that copies properties from the given original object
	 * 
	 * @param original
	 *            the original object
	 */
	public VariableWrapperParamsBuilder(VariableWrapperParams original) {

		this.itemData = original.getItemData();
		this.variableNames = original.getVariableNames();
		this.context = original.getContext();
		this.xclass = original.getXclass();
		this.position = original.getPosition();
		this.noteNumber = original.getNoteNumber();
		this.firstReferenceNoteNumber = original.getFirstReferenceNoteNumber();
		this.citationNumber = original.getCitationNumber();
		this.index = original.getIndex();
		this.mode = original.getMode();
	}

	public VariableWrapperParams build() {
		return new VariableWrapperParams(itemData, variableNames, context,
				xclass, position, noteNumber, firstReferenceNoteNumber,
				citationNumber, index, mode);
	}

}
