// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc;

/**
 * Selection modes for
 * {@link CSL#makeBibliography(SelectionMode, de.undercouch.citeproc.csl.CSLItemData[])}
 * .
 * 
 * @author Michel Kraemer
 */
public enum SelectionMode {
	SELECT("select"), INCLUDE("include"), EXCLUDE("exclude");

	private String name;

	private SelectionMode(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return name;
	}

	/**
	 * Converts the given string to a SelectionMode
	 * 
	 * @param str
	 *            the string
	 * @return the converted SelectionMode
	 */
	public static SelectionMode fromString(String str) {
		if (str.equals("select")) {
			return SELECT;
		}
		if (str.equals("include")) {
			return INCLUDE;
		}
		if (str.equals("exclude")) {
			return EXCLUDE;
		}
		throw new IllegalArgumentException("Unknown SelectionMode: " + str);
	}
}
