// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.endnote;

/**
 * Valid EndNote reference types.
 * 
 * @author Michel Kraemer
 */
public enum EndNoteType {
	GENERIC("Generic"), ARTWORK("Artwork"), AUDIOVISUAL_MATERIAL(
			"Audiovisual Material"), BILL("Bill"), BOOK("Book"), BOOK_SECTION(
			"Book Section"), CASE("Case"), CHART_OR_TABLE("Chart or Table"), CLASSICAL_WORK(
			"Classical Work"), COMPUTER_PROGRAM("Computer Program"), CONFERENCE_PAPER(
			"Conference Paper"), CONFERENCE_PROCEEDINGS(
			"Conference Proceedings"), EDITED_BOOK("Edited Book"), EQUATION(
			"Equation"), ELECTRONIC_ARTICLE("Electronic Article"), ELECTRONIC_BOOK(
			"Electronic Book"), ELECTRONIC_SOURCE("Electronic Source"), FIGURE(
			"Figure"), FILM_OR_BROADCAST("Film or Broadcast"), GOVERNMENT_DOCUMENT(
			"Government Document"), HEARING("Hearing"), JOURNAL_ARTICLE(
			"Journal Article"), LEGAL_RULE_REGULATION("Legal Rule/Regulation"), MAGAZINE_ARTICLE(
			"Magazine Article"), MANUSCRIPT("Manuscript"), MAP("Map"), NEWSPAPER_ARTICLE(
			"Newspaper Article"), ONLINE_DATABASE("Online Database"), ONLINE_MULTIMEDIA(
			"Online Multimedia"), PATENT("Patent"), PERSONAL_COMMUNICATION(
			"Personal Communication"), REPORT("Report"), STATUTE("Statute"), THESIS(
			"Thesis"), UNPUBLISHED_WORK("Unpublished Work"), UNUSED_1(
			"Unused 1"), UNUSED_2("Unused 2"), UNUSED_3("Unused 3");

	private String name;

	private EndNoteType(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return name;
	}

	/**
	 * Converts the given string to a EndNoteType
	 * 
	 * @param str
	 *            the string
	 * @return the converted EndNoteType
	 */
	public static EndNoteType fromString(String str) {
		if (str.equals("Generic")) {
			return GENERIC;
		}
		if (str.equals("Artwork")) {
			return ARTWORK;
		}
		if (str.equals("Audiovisual Material")) {
			return AUDIOVISUAL_MATERIAL;
		}
		if (str.equals("Bill")) {
			return BILL;
		}
		if (str.equals("Book")) {
			return BOOK;
		}
		if (str.equals("Book Section")) {
			return BOOK_SECTION;
		}
		if (str.equals("Case")) {
			return CASE;
		}
		if (str.equals("Chart or Table")) {
			return CHART_OR_TABLE;
		}
		if (str.equals("Classical Work")) {
			return CLASSICAL_WORK;
		}
		if (str.equals("Computer Program")) {
			return COMPUTER_PROGRAM;
		}
		if (str.equals("Conference Paper")) {
			return CONFERENCE_PAPER;
		}
		if (str.equals("Conference Proceedings")) {
			return CONFERENCE_PROCEEDINGS;
		}
		if (str.equals("Edited Book")) {
			return EDITED_BOOK;
		}
		if (str.equals("Equation")) {
			return EQUATION;
		}
		if (str.equals("Electronic Article")) {
			return ELECTRONIC_ARTICLE;
		}
		if (str.equals("Electronic Book")) {
			return ELECTRONIC_BOOK;
		}
		if (str.equals("Electronic Source")) {
			return ELECTRONIC_SOURCE;
		}
		if (str.equals("Figure")) {
			return FIGURE;
		}
		if (str.equals("Film or Broadcast")) {
			return FILM_OR_BROADCAST;
		}
		if (str.equals("Government Document")) {
			return GOVERNMENT_DOCUMENT;
		}
		if (str.equals("Hearing")) {
			return HEARING;
		}
		if (str.equals("Journal Article")) {
			return JOURNAL_ARTICLE;
		}
		if (str.equals("Legal Rule/Regulation")) {
			return LEGAL_RULE_REGULATION;
		}
		if (str.equals("Magazine Article")) {
			return MAGAZINE_ARTICLE;
		}
		if (str.equals("Manuscript")) {
			return MANUSCRIPT;
		}
		if (str.equals("Map")) {
			return MAP;
		}
		if (str.equals("Newspaper Article")) {
			return NEWSPAPER_ARTICLE;
		}
		if (str.equals("Online Database")) {
			return ONLINE_DATABASE;
		}
		if (str.equals("Online Multimedia")) {
			return ONLINE_MULTIMEDIA;
		}
		if (str.equals("Patent")) {
			return PATENT;
		}
		if (str.equals("Personal Communication")) {
			return PERSONAL_COMMUNICATION;
		}
		if (str.equals("Report")) {
			return REPORT;
		}
		if (str.equals("Statute")) {
			return STATUTE;
		}
		if (str.equals("Thesis")) {
			return THESIS;
		}
		if (str.equals("Unpublished Work")) {
			return UNPUBLISHED_WORK;
		}
		if (str.equals("Unused 1")) {
			return UNUSED_1;
		}
		if (str.equals("Unused 2")) {
			return UNUSED_2;
		}
		if (str.equals("Unused 3")) {
			return UNUSED_3;
		}
		throw new IllegalArgumentException("Unknown EndNoteType: " + str);
	}
}
