// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

/**
 * Valid citation labels
 * 
 * @author Michel Kraemer
 */
public enum CSLLabel {
	BOOK("book"), CHAPTER("chapter"), COLUMN("column"), FIGURE("figure"), FOLIO(
			"folio"), ISSUE("issue"), LINE("line"), NOTE("note"), OPUS("opus"), PAGE(
			"page"), PARAGRAPH("paragraph"), PART("part"), SECTION("section"), SUB_VERBO(
			"sub-verbo"), VERSE("verse"), VOLUME("volume");

	private String name;

	private CSLLabel(String name) {
		this.name = name;
	}

	@Override
	public String toString() {
		return name;
	}

	/**
	 * Converts the given string to a CSLLabel
	 * 
	 * @param str
	 *            the string
	 * @return the converted CSLLabel
	 */
	public static CSLLabel fromString(String str) {
		if (str.equals("book")) {
			return BOOK;
		}
		if (str.equals("chapter")) {
			return CHAPTER;
		}
		if (str.equals("column")) {
			return COLUMN;
		}
		if (str.equals("figure")) {
			return FIGURE;
		}
		if (str.equals("folio")) {
			return FOLIO;
		}
		if (str.equals("issue")) {
			return ISSUE;
		}
		if (str.equals("line")) {
			return LINE;
		}
		if (str.equals("note")) {
			return NOTE;
		}
		if (str.equals("opus")) {
			return OPUS;
		}
		if (str.equals("page")) {
			return PAGE;
		}
		if (str.equals("paragraph")) {
			return PARAGRAPH;
		}
		if (str.equals("part")) {
			return PART;
		}
		if (str.equals("section")) {
			return SECTION;
		}
		if (str.equals("sub-verbo") || str.equals("sub verbo")) {
			return SUB_VERBO;
		}
		if (str.equals("verse")) {
			return VERSE;
		}
		if (str.equals("volume")) {
			return VOLUME;
		}
		throw new IllegalArgumentException("Unknown CSLLabel: " + str);
	}
}
