// Copyright 2013 Michel Kraemer
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package de.undercouch.citeproc.csl;

import java.util.Map;

/**
 * Builder for {@link CSLCitation}
 * 
 * @author Michel Kraemer
 */
public class CSLCitationBuilder {
	private CSLCitationItem[] citationItems;

	private String citationID;
	private CSLProperties properties;

	public CSLCitationBuilder(CSLCitationItem... citationItems) {
		this.citationItems = citationItems;

		this.citationID = Long.toString(
				(long) Math.floor(Math.random() * 100000000000000L), 32);
		this.properties = new CSLProperties();

	}

	public CSLCitationBuilder citationID(String citationID) {
		this.citationID = citationID;
		return this;
	}

	public CSLCitationBuilder properties(CSLProperties properties) {
		this.properties = properties;
		return this;
	}

	/**
	 * Creates a builder that copies properties from the given original object
	 * 
	 * @param original
	 *            the original object
	 */
	public CSLCitationBuilder(CSLCitation original) {
		this.citationItems = original.getCitationItems();
		this.citationID = original.getCitationID();
		this.properties = original.getProperties();
	}

	public CSLCitation build() {
		return new CSLCitation(citationItems, citationID, properties);
	}

	public CSLCitationBuilder citationID(long citationID) {
		citationID(String.valueOf(citationID));
		return this;
	}
}
