/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.script;

import de.undercouch.citeproc.script.JREScriptRunner;
import de.undercouch.citeproc.script.ScriptRunner;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.SystemUtils;

public class ScriptRunnerFactory {
    private static AtomicReference<RunnerType> runner = new AtomicReference<RunnerType>(RunnerType.AUTO);

    public static RunnerType setRunnerType(RunnerType type) {
        return runner.getAndSet(type);
    }

    private static ScriptRunner createJreRunner() {
        if (!SystemUtils.isJavaVersionAtLeast((int)170)) {
            throw new RuntimeException("You're using a JRE 6 or lower and Mozilla Rhino was not found in the classpath. The bundled Rhino in JRE 6 does not support E4X (ECMAScript for XML) which is needed for citeproc-java. Either include Rhino in your classpath or upgrade to a newer JRE.");
        }
        return new JREScriptRunner();
    }

    private static ScriptRunner createRhinoRunner() {
        try {
            return (ScriptRunner)Class.forName("de.undercouch.citeproc.script.RhinoScriptRunner").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("No JavaScript engine found", e);
        }
    }

    public static ScriptRunner createRunner() {
        RunnerType t = runner.get();
        switch (t) {
            case AUTO: {
                try {
                    Class.forName("org.mozilla.javascript.Context");
                }
                catch (ClassNotFoundException e) {
                    return ScriptRunnerFactory.createJreRunner();
                }
                return ScriptRunnerFactory.createRhinoRunner();
            }
            case JRE: {
                return ScriptRunnerFactory.createJreRunner();
            }
            case RHINO: {
                return ScriptRunnerFactory.createRhinoRunner();
            }
        }
        throw new RuntimeException("Invalid runner type");
    }

    public static enum RunnerType {
        AUTO,
        JRE,
        RHINO;

    }
}

