/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.script;

import de.undercouch.citeproc.helper.CSLUtils;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.script.AbstractScriptRunner;
import de.undercouch.citeproc.script.RhinoJsonBuilder;
import de.undercouch.citeproc.script.ScriptRunnerException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Wrapper;

public class RhinoScriptRunner
extends AbstractScriptRunner {
    private static Map<URL, Script> compiledScripts = new ConcurrentHashMap<URL, Script>();
    private final Scriptable scope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoScriptRunner() {
        Context context = Context.enter();
        try {
            this.scope = context.initStandardObjects();
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public void put(String key, Object value) {
        this.scope.put(key, this.scope, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadScript(URL url) throws IOException, ScriptRunnerException {
        Script s = compiledScripts.get(url);
        if (s != null) {
            Context context = Context.enter();
            try {
                s.exec(context, this.scope);
                return;
            }
            finally {
                Context.exit();
            }
        }
        if (url.getPath().endsWith(".js")) {
            String name = url.getPath().substring(0, url.getPath().length() - 3);
            name = name.substring(name.lastIndexOf(47) + 1);
            URL fileUrl = new URL(url, name = name + ".dat");
            if (fileUrl != null) {
                Context context = Context.enter();
                try {
                    byte[] data = CSLUtils.readURL(fileUrl);
                    GeneratedClassLoader loader = SecurityController.createLoader((ClassLoader)context.getApplicationClassLoader(), null);
                    Class clazz = loader.defineClass(null, data);
                    loader.linkClass(clazz);
                    s = (Script)clazz.newInstance();
                    compiledScripts.put(url, s);
                    s.exec(context, this.scope);
                    return;
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                finally {
                    Context.exit();
                }
            }
        }
        super.loadScript(url);
    }

    @Override
    public Object eval(String code) throws ScriptRunnerException {
        Context context = Context.enter();
        try {
            Object object = RhinoScriptRunner.unwrap(context.evaluateString(this.scope, code, "<code>", 1, null));
            return object;
        }
        catch (RhinoException e) {
            throw new ScriptRunnerException("Could not execute code", e);
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public Object eval(Reader reader) throws ScriptRunnerException, IOException {
        Context context = Context.enter();
        try {
            Object object = RhinoScriptRunner.unwrap(context.evaluateReader(this.scope, reader, "<code>", 1, null));
            return object;
        }
        catch (RhinoException e) {
            throw new ScriptRunnerException("Could not execute script", e);
        }
        finally {
            Context.exit();
        }
    }

    private static Object unwrap(Object o) {
        if (o instanceof Wrapper) {
            return ((Wrapper)o).unwrap();
        }
        return o;
    }

    @Override
    public JsonBuilder createJsonBuilder() {
        return new RhinoJsonBuilder(this.scope, this);
    }

    @Override
    public Object callMethod(String obj, String name, Object ... args) throws ScriptRunnerException {
        try {
            Object[] p = this.convertArguments(args);
            ScriptableObject so = (ScriptableObject)this.scope.get(obj, this.scope);
            return ScriptableObject.callMethod((Scriptable)so, (String)name, (Object[])p);
        }
        catch (RhinoException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    @Override
    public Object callMethod(String obj, String name, String[] argument) throws ScriptRunnerException {
        try {
            Object p = this.createJsonBuilder().toJson(argument);
            ScriptableObject so = (ScriptableObject)this.scope.get(obj, this.scope);
            return ScriptableObject.callMethod((Scriptable)so, (String)name, (Object[])new Object[]{p});
        }
        catch (RhinoException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }
}

