/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.script;

import de.undercouch.citeproc.csl.CSLLabel;
import de.undercouch.citeproc.csl.CSLType;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonBuilderFactory;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;

public class RhinoJsonBuilder
implements JsonBuilder {
    private final Scriptable scope;
    private final JsonBuilderFactory factory;
    private final Scriptable obj;

    public RhinoJsonBuilder(Scriptable scope, JsonBuilderFactory factory) {
        this.scope = scope;
        this.factory = factory;
        NativeObject no = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)no, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
        this.obj = no;
    }

    @Override
    public JsonBuilder add(String name, Object o) {
        this.obj.put(name, this.obj, RhinoJsonBuilder.toJson(o, this.scope, this.factory));
        return this;
    }

    private static Object toJson(Object obj, Scriptable scope, JsonBuilderFactory factory) {
        if (obj instanceof JsonObject) {
            obj = ((JsonObject)obj).toJson(factory.createJsonBuilder());
        } else if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            NativeArray na = new NativeArray((long)len);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)na, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
            for (int i = 0; i < len; ++i) {
                Object ao = Array.get(obj, i);
                na.put(i, (Scriptable)na, RhinoJsonBuilder.toJson(ao, scope, factory));
            }
            obj = na;
        } else if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            NativeArray na = new NativeArray((long)coll.size());
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)na, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Array);
            int i = 0;
            for (Object ao : coll) {
                na.put(i, (Scriptable)na, RhinoJsonBuilder.toJson(ao, scope, factory));
                ++i;
            }
            obj = na;
        } else if (obj instanceof CSLType || obj instanceof CSLLabel) {
            obj = obj.toString();
        } else if (obj instanceof Map) {
            Map m = (Map)obj;
            NativeObject no = new NativeObject();
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)no, (Scriptable)scope, (TopLevel.Builtins)TopLevel.Builtins.Object);
            for (Map.Entry e : m.entrySet()) {
                String key = e.getKey().toString();
                no.put(key, (Scriptable)no, RhinoJsonBuilder.toJson(e.getValue(), scope, factory));
            }
            obj = no;
        }
        return obj;
    }

    @Override
    public Object build() {
        return this.obj;
    }

    @Override
    public Object toJson(Object o) {
        return RhinoJsonBuilder.toJson(o, this.scope, this.factory);
    }
}

