/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.mendeley;

import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLDateBuilder;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLItemDataBuilder;
import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.CSLNameBuilder;
import de.undercouch.citeproc.csl.CSLType;
import java.util.List;
import java.util.Map;

public class MendeleyConverter {
    private static final String FIELD_ABSTRACT = "abstract";
    private static final String FIELD_AUTHORS = "authors";
    private static final String FIELD_BOOK = "book";
    private static final String FIELD_CHAPTER = "chapter";
    private static final String FIELD_CITATION_KEY = "citation_key";
    private static final String FIELD_CITY = "city";
    private static final String FIELD_DATE_ACCESSED = "dateAccessed";
    private static final String FIELD_DAY = "day";
    private static final String FIELD_DISTRIBUTOR = "distributor";
    private static final String FIELD_DOI = "doi";
    private static final String FIELD_EDITION = "edition";
    private static final String FIELD_EDITORS = "editors";
    private static final String FIELD_ENCYCLOPEDIA = "encyclopedia";
    private static final String FIELD_FORENAME = "forename";
    private static final String FIELD_GENRE = "genre";
    private static final String FIELD_ISBN = "isbn";
    private static final String FIELD_ISSUE = "issue";
    private static final String FIELD_ISSUER = "issuer";
    private static final String FIELD_MONTH = "month";
    private static final String FIELD_NOTE = "note";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_PAGES = "pages";
    private static final String FIELD_PUBLICATION = "publication";
    private static final String FIELD_PUBLICATION_OUTLET = "publication_outlet";
    private static final String FIELD_PUBLISHED_IN = "published_in";
    private static final String FIELD_PUBLISHER = "publisher";
    private static final String FIELD_REVISION_NUMBER = "revisionNumber";
    private static final String FIELD_SHORT_TITLE = "shortTitle";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_SURNAME = "surname";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_URL = "url";
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_VOLUME = "volume";
    private static final String FIELD_YEAR = "year";
    private static final String TYPE_BILL = "Bill";
    private static final String TYPE_BOOK = "Book";
    private static final String TYPE_BOOK_SECTION = "Book Section";
    private static final String TYPE_CASE = "Case";
    private static final String TYPE_COMPUTER_PROGRAM = "Computer Program";
    private static final String TYPE_CONFERENCE_PROCEEDINGS = "Conference Proceedings";
    private static final String TYPE_ENCYCLOPEDIA_ARTICLE = "Encyclopedia Article";
    private static final String TYPE_FILM = "Film";
    private static final String TYPE_GENERIC = "Generic";
    private static final String TYPE_HEARING = "Hearing";
    private static final String TYPE_JOURNAL_ARTICLE = "Journal Article";
    private static final String TYPE_MAGAZINE_ARTICLE = "Magazine Article";
    private static final String TYPE_NEWSPAPER_ARTICLE = "Newspaper Article";
    private static final String TYPE_PATENT = "Patent";
    private static final String TYPE_REPORT = "Report";
    private static final String TYPE_STATUTE = "Statute";
    private static final String TYPE_TELEVISION_BROADCAST = "Television Broadcast";
    private static final String TYPE_THESIS = "Thesis";
    private static final String TYPE_WEB_PAGE = "Web Page";
    private static final String TYPE_WORKING_PAPER = "Working Paper";

    public static CSLItemData convert(String documentId, Map<String, Object> document) {
        String id = (String)document.get(FIELD_CITATION_KEY);
        if (id == null) {
            id = documentId;
        }
        String mtype = MendeleyConverter.strOrNull(document.get(FIELD_TYPE));
        CSLType type = MendeleyConverter.toType(mtype);
        CSLItemDataBuilder builder = new CSLItemDataBuilder().id(id).type(type);
        if (document.containsKey(FIELD_AUTHORS)) {
            List al = (List)document.get(FIELD_AUTHORS);
            builder.author(MendeleyConverter.toAuthors(al));
        }
        if (document.containsKey(FIELD_EDITORS)) {
            List el = (List)document.get(FIELD_EDITORS);
            CSLName[] editors = MendeleyConverter.toAuthors(el);
            builder.editor(editors);
            builder.collectionEditor(editors);
            builder.containerAuthor(editors);
        }
        if (document.containsKey(FIELD_YEAR)) {
            CSLDateBuilder db = new CSLDateBuilder();
            int year = Integer.parseInt(document.get(FIELD_YEAR).toString());
            if (document.containsKey(FIELD_MONTH)) {
                int month = Integer.parseInt(document.get(FIELD_MONTH).toString());
                if (document.containsKey(FIELD_DAY)) {
                    int day = Integer.parseInt(document.get(FIELD_DAY).toString());
                    db.dateParts(year, month, day);
                } else {
                    db.dateParts(year, month);
                }
            } else {
                db.dateParts(year);
            }
            CSLDate d = db.build();
            builder.issued(d);
            builder.eventDate(d);
        }
        if (mtype.equalsIgnoreCase(TYPE_COMPUTER_PROGRAM) && document.containsKey(FIELD_VERSION)) {
            builder.number(MendeleyConverter.strOrNull(document.get(FIELD_VERSION)));
        } else if (document.containsKey(FIELD_REVISION_NUMBER)) {
            builder.number(MendeleyConverter.strOrNull(document.get(FIELD_REVISION_NUMBER)));
        } else {
            builder.number(MendeleyConverter.strOrNull(document.get(FIELD_NUMBER)));
        }
        String containerTitle = mtype.equalsIgnoreCase(TYPE_BOOK_SECTION) && document.containsKey(FIELD_BOOK) ? MendeleyConverter.strOrNull(document.get(FIELD_BOOK)) : (mtype.equalsIgnoreCase(TYPE_ENCYCLOPEDIA_ARTICLE) && document.containsKey(FIELD_ENCYCLOPEDIA) ? MendeleyConverter.strOrNull(document.get(FIELD_ENCYCLOPEDIA)) : (document.containsKey(FIELD_PUBLISHED_IN) ? MendeleyConverter.strOrNull(document.get(FIELD_PUBLISHED_IN)) : (document.containsKey(FIELD_PUBLICATION_OUTLET) ? MendeleyConverter.strOrNull(document.get(FIELD_PUBLICATION_OUTLET)) : MendeleyConverter.strOrNull(document.get(FIELD_PUBLICATION)))));
        builder.containerTitle(containerTitle);
        builder.collectionTitle(containerTitle);
        if (mtype.equalsIgnoreCase(TYPE_PATENT) && document.containsKey(FIELD_ISSUER)) {
            builder.publisher(MendeleyConverter.strOrNull(document.get(FIELD_ISSUER)));
        } else if (mtype.equalsIgnoreCase(TYPE_PATENT) && document.containsKey(FIELD_SOURCE)) {
            builder.publisher(MendeleyConverter.strOrNull(document.get(FIELD_SOURCE)));
        } else if (mtype.equalsIgnoreCase(TYPE_FILM) && document.containsKey(FIELD_DISTRIBUTOR)) {
            builder.publisher(MendeleyConverter.strOrNull(document.get(FIELD_DISTRIBUTOR)));
        } else {
            builder.publisher(MendeleyConverter.strOrNull(document.get(FIELD_PUBLISHER)));
        }
        if (document.containsKey(FIELD_DATE_ACCESSED)) {
            builder.accessed(new CSLDateBuilder().raw(MendeleyConverter.strOrNull(document.get(FIELD_DATE_ACCESSED))).build());
        }
        builder.abstrct(MendeleyConverter.strOrNull(document.get(FIELD_ABSTRACT)));
        builder.chapterNumber(MendeleyConverter.strOrNull(document.get(FIELD_CHAPTER)));
        builder.eventplace(MendeleyConverter.strOrNull(document.get(FIELD_CITY)));
        builder.publisherPlace(MendeleyConverter.strOrNull(document.get(FIELD_CITY)));
        builder.DOI(MendeleyConverter.strOrNull(document.get(FIELD_DOI)));
        builder.edition(MendeleyConverter.strOrNull(document.get(FIELD_EDITION)));
        builder.genre(MendeleyConverter.strOrNull(document.get(FIELD_GENRE)));
        builder.ISBN(MendeleyConverter.strOrNull(document.get(FIELD_ISBN)));
        builder.issue(MendeleyConverter.strOrNull(document.get(FIELD_ISSUE)));
        builder.note(MendeleyConverter.strOrNull(document.get(FIELD_NOTE)));
        builder.page(MendeleyConverter.strOrNull(document.get(FIELD_PAGES)));
        builder.shortTitle(MendeleyConverter.strOrNull(document.get(FIELD_SHORT_TITLE)));
        builder.title(MendeleyConverter.strOrNull(document.get(FIELD_TITLE)));
        builder.URL(MendeleyConverter.strOrNull(document.get(FIELD_URL)));
        builder.volume(MendeleyConverter.strOrNull(document.get(FIELD_VOLUME)));
        return builder.build();
    }

    private static String strOrNull(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    private static CSLName[] toAuthors(List<Map<String, Object>> authors) {
        CSLName[] result = new CSLName[authors.size()];
        int i = 0;
        for (Map<String, Object> a : authors) {
            CSLNameBuilder builder = new CSLNameBuilder();
            if (a.containsKey(FIELD_FORENAME)) {
                builder.given(MendeleyConverter.strOrNull(a.get(FIELD_FORENAME)));
            }
            if (a.containsKey(FIELD_SURNAME)) {
                builder.family(MendeleyConverter.strOrNull(a.get(FIELD_SURNAME)));
            }
            builder.parseNames(true);
            result[i] = builder.build();
            ++i;
        }
        return result;
    }

    private static CSLType toType(String type) {
        if (type.equalsIgnoreCase(TYPE_BILL)) {
            return CSLType.BILL;
        }
        if (type.equalsIgnoreCase(TYPE_BOOK)) {
            return CSLType.BOOK;
        }
        if (type.equalsIgnoreCase(TYPE_BOOK_SECTION)) {
            return CSLType.CHAPTER;
        }
        if (type.equalsIgnoreCase(TYPE_CASE)) {
            return CSLType.ARTICLE;
        }
        if (type.equalsIgnoreCase(TYPE_COMPUTER_PROGRAM)) {
            return CSLType.ARTICLE;
        }
        if (type.equalsIgnoreCase(TYPE_CONFERENCE_PROCEEDINGS)) {
            return CSLType.PAPER_CONFERENCE;
        }
        if (type.equalsIgnoreCase(TYPE_ENCYCLOPEDIA_ARTICLE)) {
            return CSLType.ENTRY_ENCYCLOPEDIA;
        }
        if (type.equalsIgnoreCase(TYPE_FILM)) {
            return CSLType.MOTION_PICTURE;
        }
        if (type.equalsIgnoreCase(TYPE_GENERIC)) {
            return CSLType.ARTICLE;
        }
        if (type.equalsIgnoreCase(TYPE_HEARING)) {
            return CSLType.SPEECH;
        }
        if (type.equalsIgnoreCase(TYPE_JOURNAL_ARTICLE)) {
            return CSLType.ARTICLE_JOURNAL;
        }
        if (type.equalsIgnoreCase(TYPE_MAGAZINE_ARTICLE)) {
            return CSLType.ARTICLE_MAGAZINE;
        }
        if (type.equalsIgnoreCase(TYPE_NEWSPAPER_ARTICLE)) {
            return CSLType.ARTICLE_NEWSPAPER;
        }
        if (type.equalsIgnoreCase(TYPE_PATENT)) {
            return CSLType.PATENT;
        }
        if (type.equalsIgnoreCase(TYPE_REPORT)) {
            return CSLType.REPORT;
        }
        if (type.equalsIgnoreCase(TYPE_STATUTE)) {
            return CSLType.LEGISLATION;
        }
        if (type.equalsIgnoreCase(TYPE_TELEVISION_BROADCAST)) {
            return CSLType.BROADCAST;
        }
        if (type.equalsIgnoreCase(TYPE_THESIS)) {
            return CSLType.THESIS;
        }
        if (type.equalsIgnoreCase(TYPE_WEB_PAGE)) {
            return CSLType.WEBPAGE;
        }
        if (type.equalsIgnoreCase(TYPE_WORKING_PAPER)) {
            return CSLType.ARTICLE;
        }
        return CSLType.ARTICLE;
    }
}

