/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.mendeley;

import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.json.JsonLexer;
import de.undercouch.citeproc.helper.json.JsonParser;
import de.undercouch.citeproc.helper.oauth.OAuth;
import de.undercouch.citeproc.helper.oauth.Token;
import de.undercouch.citeproc.helper.oauth.UnauthorizedException;
import de.undercouch.citeproc.mendeley.MendeleyConnector;
import de.undercouch.citeproc.mendeley.MendeleyConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class DefaultMendeleyConnector
implements MendeleyConnector {
    private static final String OAUTH_REQUEST_TOKEN_URL = "http://api.mendeley.com/oauth/request_token/";
    private static final String OAUTH_AUTHORIZATION_URL = "http://api.mendeley.com/oauth/authorize/?oauth_token=";
    private static final String OAUTH_ACCESS_TOKEN_URL = "http://api.mendeley.com/oauth/access_token/";
    private static final String MENDELEY_LIBRARY_ENDPOINT = "http://api.mendeley.com/oapi/library/";
    private static final String MENDELEY_DOCUMENTS_ENDPOINT = "http://api.mendeley.com/oapi/library/documents/";
    private final OAuth auth;
    private Token requestToken;
    private Token accessToken;

    public DefaultMendeleyConnector(String consumerKey, String consumerSecret) {
        this.auth = new OAuth(consumerKey, consumerSecret);
    }

    @Override
    public String getAuthorizationURL() throws IOException {
        try {
            this.requestToken = this.auth.requestTemporaryCredentials(new URL(OAUTH_REQUEST_TOKEN_URL), OAuth.Method.GET, "oob");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return OAUTH_AUTHORIZATION_URL + this.requestToken.getToken();
    }

    @Override
    public void authorize(String verificationCode) throws IOException {
        try {
            this.accessToken = this.auth.requestTokenCredentials(new URL(OAUTH_ACCESS_TOKEN_URL), OAuth.Method.GET, this.requestToken, verificationCode);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAccessToken(String token, String secret) {
        this.accessToken = new Token(token, secret);
    }

    @Override
    public String getAccessTokenValue() {
        if (this.accessToken == null) {
            return null;
        }
        return this.accessToken.getToken();
    }

    @Override
    public String getAccessTokenSecret() {
        if (this.accessToken == null) {
            return null;
        }
        return this.accessToken.getSecret();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> performRequest(String url) throws IOException {
        if (this.accessToken == null) {
            throw new UnauthorizedException("Access token has not yet been requested");
        }
        URL u = new URL(url);
        InputStream is = this.auth.request(u, OAuth.Method.GET, this.accessToken);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            Map<String, Object> map = new JsonParser(new JsonLexer(r)).parseObject();
            return map;
        }
        finally {
            this.consumeResponse(is);
            is.close();
        }
    }

    @Override
    public List<String> getDocuments() throws IOException {
        Map<String, Object> response = this.performRequest(MENDELEY_LIBRARY_ENDPOINT);
        List documentIds = (List)response.get("document_ids");
        return documentIds;
    }

    private void consumeResponse(InputStream is) throws IOException {
        byte[] buf = new byte[8192];
        while (is.read(buf) >= 0) {
        }
    }

    @Override
    public CSLItemData getDocument(String documentId) throws IOException {
        Map<String, Object> response = this.performRequest(MENDELEY_DOCUMENTS_ENDPOINT + documentId);
        return MendeleyConverter.convert(documentId, response);
    }
}

