/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.mendeley;

import de.undercouch.citeproc.helper.oauth.AuthenticationStore;
import de.undercouch.citeproc.mendeley.MendeleyConnector;
import de.undercouch.citeproc.mendeley.MendeleyConnectorAdapter;
import java.io.IOException;

public class AuthenticatedMendeleyConnector
extends MendeleyConnectorAdapter {
    private final AuthenticationStore store;

    public AuthenticatedMendeleyConnector(MendeleyConnector delegate, AuthenticationStore store) {
        super(delegate);
        this.store = store;
        String token = store.getToken();
        String secret = store.getSecret();
        if (token != null && secret != null) {
            delegate.setAccessToken(token, secret);
        }
    }

    @Override
    public void authorize(String verificationCode) throws IOException {
        super.authorize(verificationCode);
        try {
            this.store.save(this.getAccessTokenValue(), this.getAccessTokenSecret());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not store access token", e);
        }
    }

    @Override
    public void setAccessToken(String token, String secret) {
        super.setAccessToken(token, secret);
        try {
            this.store.save(token, secret);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not store access token", e);
        }
    }
}

