/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.tool.internal;

import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.json.JsonLexer;
import de.undercouch.citeproc.helper.json.JsonParser;
import de.undercouch.citeproc.helper.json.StringJsonBuilderFactory;
import de.undercouch.citeproc.mendeley.MendeleyConnector;
import de.undercouch.citeproc.mendeley.MendeleyConnectorAdapter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CachingMendeleyConnector
extends MendeleyConnectorAdapter {
    private final Object _db;
    private final Set<String> _documentIds;
    private final Map<String, String> _documents;

    public CachingMendeleyConnector(MendeleyConnector delegate, File cacheFile) {
        super(delegate);
        Map<String, String> documents;
        Set<String> documentIds;
        Object db;
        try {
            Class<?> dbMakerClass = CachingMendeleyConnector.class.getClassLoader().loadClass("org.mapdb.DBMaker");
            Method newFileDB = dbMakerClass.getMethod("newFileDB", File.class);
            Object dbMaker = newFileDB.invoke(null, cacheFile);
            Method closeOnJvmShutdown = dbMakerClass.getMethod("closeOnJvmShutdown", new Class[0]);
            closeOnJvmShutdown.invoke(dbMaker, new Object[0]);
            Method make = dbMakerClass.getMethod("make", new Class[0]);
            db = make.invoke(dbMaker, new Object[0]);
            Class<?> dbClass = db.getClass();
            Method getTreeSet = dbClass.getMethod("getTreeSet", String.class);
            documentIds = (Set)getTreeSet.invoke(db, "documentIds");
            Method getHashMap = dbClass.getMethod("getHashMap", String.class);
            documents = (Map)getHashMap.invoke(db, "documents");
        }
        catch (Exception e) {
            db = null;
            documentIds = new HashSet<String>();
            documents = new HashMap<String, String>();
        }
        this._db = db;
        this._documentIds = documentIds;
        this._documents = documents;
    }

    @Override
    public List<String> getDocuments() throws IOException {
        if (!this._documentIds.isEmpty()) {
            return new ArrayList<String>(this._documentIds);
        }
        List<String> ids = super.getDocuments();
        try {
            this._documentIds.addAll(ids);
            this.commit();
        }
        catch (RuntimeException e) {
            this.rollback();
            throw e;
        }
        return ids;
    }

    @Override
    public CSLItemData getDocument(String documentId) throws IOException {
        CSLItemData item;
        String doc = this._documents.get(documentId);
        if (doc == null) {
            item = super.getDocument(documentId);
            doc = (String)item.toJson(new StringJsonBuilderFactory().createJsonBuilder());
            try {
                this._documents.put(documentId, doc);
                this.commit();
            }
            catch (RuntimeException e) {
                this.rollback();
                throw e;
            }
        } else {
            Map<String, Object> m = new JsonParser(new JsonLexer(new StringReader(doc))).parseObject();
            item = CSLItemData.fromJson(m);
        }
        return item;
    }

    public boolean containsDocumentId(String documentId) {
        return this._documents.containsKey(documentId);
    }

    public boolean hasDocumentList() {
        return !this._documentIds.isEmpty();
    }

    public void clear() {
        this._documentIds.clear();
        this._documents.clear();
    }

    private void commit() {
        if (this._db == null) {
            return;
        }
        try {
            Method m = this._db.getClass().getMethod("commit", new Class[0]);
            m.invoke(this._db, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }

    private void rollback() {
        if (this._db == null) {
            return;
        }
        try {
            Method m = this._db.getClass().getMethod("rollback", new Class[0]);
            m.invoke(this._db, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not roll back transaction", e);
        }
    }
}

