/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.tool;

import de.undercouch.citeproc.helper.tool.InvalidOptionException;
import de.undercouch.citeproc.helper.tool.MissingArgumentException;
import de.undercouch.citeproc.helper.tool.Option;
import de.undercouch.citeproc.helper.tool.OptionGroup;
import de.undercouch.citeproc.helper.tool.Value;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class OptionParser {
    public static <T> void usage(String command, String description, OptionGroup<T> options, PrintStream out) {
        out.println("Usage: " + command);
        out.println(description);
        out.println();
        int firstColumnWidth = 0;
        int secondColumnWidth = 0;
        for (Option<T> o : options.getFlatOptions()) {
            int fcw;
            if (o.getShortName() != null && (fcw = o.getShortName().length() + 1) > firstColumnWidth) {
                firstColumnWidth = fcw;
            }
            int scw = o.getLongName().length() + 2;
            if (o.getArgumentType() != Option.ArgumentType.NONE) {
                scw += o.getArgumentName().length() + 3;
            }
            if (scw <= secondColumnWidth) continue;
            secondColumnWidth = scw;
        }
        OptionParser.printOptions(options, out, firstColumnWidth, secondColumnWidth);
    }

    private static <T> void printOptions(OptionGroup<T> options, PrintStream out, int firstColumnWidth, int secondColumnWidth) {
        if (options.getName() != null && !options.getName().isEmpty()) {
            System.out.println();
            System.out.println(options.getName());
        }
        for (Option<T> option : options.getOptions()) {
            int sp;
            int pad;
            out.print("  ");
            if (firstColumnWidth > 0) {
                int snl = 0;
                if (option.getShortName() != null) {
                    out.print("-" + option.getShortName() + ",");
                    snl = option.getShortName().length();
                } else {
                    out.print("  ");
                }
                for (pad = firstColumnWidth - snl - 1; pad > 0; --pad) {
                    out.print(" ");
                }
            }
            int lnl = option.getLongName().length();
            out.print("--" + option.getLongName());
            if (option.getArgumentType() != Option.ArgumentType.NONE) {
                out.print(" <" + option.getArgumentName() + ">");
                lnl += option.getArgumentName().length() + 3;
            }
            for (pad = secondColumnWidth - lnl - 1; pad > 0; --pad) {
                out.print(" ");
            }
            out.print(" ");
            int w = firstColumnWidth + secondColumnWidth + 4;
            if (firstColumnWidth > 0) {
                ++w;
            }
            String desc = option.getDescription();
            while (w + desc.length() > 75 && (sp = desc.lastIndexOf(32, 74 - w)) != -1) {
                out.println(desc.substring(0, sp));
                for (int i = 0; i < w; ++i) {
                    out.print(" ");
                }
                desc = desc.substring(sp + 1);
            }
            out.println(desc);
        }
        for (OptionGroup optionGroup : options.getChildren()) {
            OptionParser.printOptions(optionGroup, out, firstColumnWidth, secondColumnWidth);
        }
    }

    public static <T> List<Value<T>> parse(String[] args, OptionGroup<T> options, T def) throws MissingArgumentException, InvalidOptionException {
        ArrayList<Value<T>> result = new ArrayList<Value<T>>();
        for (int i = 0; i < args.length; ++i) {
            String an;
            String a = args[i];
            boolean found = false;
            if (a.startsWith("--")) {
                an = a.substring(2);
                for (Option<T> o : options.getFlatOptions()) {
                    if (!o.getLongName().equals(an)) continue;
                    i += OptionParser.parseValue(o, args, i, result);
                    found = true;
                    break;
                }
            } else if (a.startsWith("-")) {
                an = a.substring(1);
                for (Option<T> o : options.getFlatOptions()) {
                    if (o.getShortName() == null || !o.getShortName().equals(an)) continue;
                    i += OptionParser.parseValue(o, args, i, result);
                    found = true;
                    break;
                }
            } else {
                result.add(new Value<T>(def, a));
                found = true;
            }
            if (found) continue;
            throw new InvalidOptionException(args[i]);
        }
        return result;
    }

    private static <T> int parseValue(Option<T> o, String[] args, int i, List<Value<T>> result) throws MissingArgumentException {
        int skip = 0;
        String value = null;
        switch (o.getArgumentType()) {
            case STRING: {
                if (args.length <= i + 1 || args[i + 1].startsWith("-")) {
                    throw new MissingArgumentException(args[i], o.getArgumentName());
                }
                value = args[i + 1];
                skip = 1;
                break;
            }
        }
        result.add(new Value<T>(o.getId(), value));
        return skip;
    }
}

