/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.tool;

import de.undercouch.citeproc.helper.tool.Option;
import de.undercouch.citeproc.helper.tool.OptionGroup;

public class OptionBuilder<T> {
    private final OptionGroup<T> options;

    public OptionBuilder() {
        this.options = new OptionGroup();
    }

    public OptionBuilder(String groupName) {
        this.options = new OptionGroup(groupName);
    }

    public OptionBuilder<T> add(T id, String longName, String description) {
        this.options.addOption(new Option<T>(id, longName, description));
        return this;
    }

    public OptionBuilder<T> add(T id, String longName, String shortName, String description) {
        this.options.addOption(new Option<T>(id, longName, shortName, description));
        return this;
    }

    public OptionBuilder<T> add(T id, String longName, String shortName, String description, String argumentName, Option.ArgumentType argumentType) {
        this.options.addOption(new Option<T>(id, longName, shortName, description, argumentName, argumentType));
        return this;
    }

    public OptionBuilder<T> add(OptionGroup<T> group) {
        this.options.addChild(group);
        return this;
    }

    public OptionGroup<T> build() {
        return this.options;
    }
}

