/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.oauth;

import de.undercouch.citeproc.helper.oauth.AuthenticationStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class FileAuthenticationStore
implements AuthenticationStore {
    private static final String TOKEN = "token";
    private static final String SECRET = "secret";
    private static final String COMMENT = "citeproc-java authentication store";
    private final File store;
    private final Properties p;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAuthenticationStore(File store) throws IOException {
        this.store = store;
        this.p = new Properties();
        if (store.exists()) {
            FileInputStream is = new FileInputStream(store);
            try {
                this.p.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }

    @Override
    public String getToken() {
        return this.p.getProperty(TOKEN);
    }

    @Override
    public String getSecret() {
        return this.p.getProperty(SECRET);
    }

    @Override
    public void save(String token, String secret) throws IOException {
        if (token == null) {
            throw new IllegalArgumentException("Access token value must not be null");
        }
        if (secret == null) {
            throw new IllegalArgumentException("Access token secret must not be null");
        }
        this.p.setProperty(TOKEN, token);
        this.p.setProperty(SECRET, secret);
        this.doSave();
    }

    @Override
    public void reset() throws IOException {
        this.p.remove(TOKEN);
        this.p.remove(SECRET);
        this.doSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave() throws IOException {
        FileOutputStream os = new FileOutputStream(this.store);
        try {
            this.p.store(os, COMMENT);
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

