/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.json;

import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonBuilderFactory;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class StringJsonBuilder
implements JsonBuilder {
    private final JsonBuilderFactory factory;
    private final StringBuilder b;
    private int c = 0;

    public StringJsonBuilder(JsonBuilderFactory factory) {
        this.factory = factory;
        this.b = new StringBuilder("{");
    }

    @Override
    public JsonBuilder add(String name, Object o) {
        if (this.c > 0) {
            this.b.append(",");
        }
        ++this.c;
        this.b.append("\"" + name + "\":");
        this.b.append(StringJsonBuilder.toJson(o, this.factory).toString());
        return this;
    }

    @Override
    public String build() {
        this.b.append("}");
        return this.b.toString();
    }

    @Override
    public Object toJson(Object arr) {
        return StringJsonBuilder.toJson(arr, this.factory);
    }

    private static Object toJson(Object obj, JsonBuilderFactory factory) {
        if (obj instanceof JsonObject) {
            return StringJsonBuilder.toJson((JsonObject)obj, factory);
        }
        if (obj instanceof Number) {
            return StringJsonBuilder.toJson((Number)obj);
        }
        if (obj instanceof Boolean) {
            return StringJsonBuilder.toJson((Boolean)obj);
        }
        if (obj.getClass().isArray()) {
            StringBuilder r = new StringBuilder();
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object ao = Array.get(obj, i);
                if (r.length() > 0) {
                    r.append(",");
                }
                r.append(StringJsonBuilder.toJson(ao, factory));
            }
            return "[" + r.toString() + "]";
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            StringBuilder r = new StringBuilder();
            for (Object ao : coll) {
                if (r.length() > 0) {
                    r.append(",");
                }
                r.append(StringJsonBuilder.toJson(ao, factory));
            }
            return "[" + r.toString() + "]";
        }
        if (obj instanceof Map) {
            Map m = (Map)obj;
            StringBuilder r = new StringBuilder();
            for (Map.Entry e : m.entrySet()) {
                if (r.length() > 0) {
                    r.append(",");
                }
                r.append(StringJsonBuilder.toJson(e.getKey(), factory));
                r.append(":");
                r.append(StringJsonBuilder.toJson(e.getValue(), factory));
            }
            return "{" + r.toString() + "}";
        }
        return StringJsonBuilder.toJson(String.valueOf(obj));
    }

    private static String toJson(String s) {
        return "\"" + StringEscapeUtils.escapeJava((String)s) + "\"";
    }

    private static String toJson(boolean b) {
        return String.valueOf(b);
    }

    private static String toJson(Number n) {
        return String.valueOf(n);
    }

    private static Object toJson(JsonObject obj, JsonBuilderFactory factory) {
        return obj.toJson(factory.createJsonBuilder());
    }
}

