/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import java.util.Collection;

public class Levenshtein {
    public static int distance(CharSequence s, CharSequence t) {
        int i;
        if (s.equals(t)) {
            return 0;
        }
        if (s.length() == 0) {
            return t.length();
        }
        if (t.length() == 0) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < s.length(); ++i) {
            int j;
            v1[0] = i + 1;
            for (j = 0; j < t.length(); ++j) {
                int cost = s.charAt(i) == t.charAt(j) ? 0 : 1;
                v1[j + 1] = Math.min(v1[j] + 1, Math.min(v0[j + 1] + 1, v0[j] + cost));
            }
            for (j = 0; j < v0.length; ++j) {
                v0[j] = v1[j];
            }
        }
        return v1[t.length()];
    }

    public static <T extends CharSequence> T findMinimum(Collection<T> ss, CharSequence t) {
        int min = Integer.MAX_VALUE;
        CharSequence result = null;
        for (CharSequence s : ss) {
            int d = Levenshtein.distance(s, t);
            if (d >= min) continue;
            min = d;
            result = s;
        }
        return (T)result;
    }
}

